/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManagerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WebWindowImpl
implements WebWindow {
    private static final long serialVersionUID = -8407026088913790772L;
    private static final Log LOG = LogFactory.getLog(WebWindowImpl.class);
    private WebClient webClient_;
    private Page enclosedPage_;
    private Object scriptObject_;
    private JavaScriptJobManager jobManager_;
    private List<WebWindowImpl> childWindows_ = new ArrayList<WebWindowImpl>();
    private String name_ = "";
    private History history_ = new History(this);
    private boolean closed_;

    @Deprecated
    protected WebWindowImpl() {
    }

    public WebWindowImpl(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.jobManager_ = new JavaScriptJobManagerImpl(this);
        this.performRegistration();
    }

    protected void performRegistration() {
        this.webClient_.registerWebWindow(this);
    }

    public WebClient getWebClient() {
        return this.webClient_;
    }

    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    public void setEnclosedPage(Page page) {
        LOG.debug((Object)("setEnclosedPage: " + page));
        if (page == this.enclosedPage_) {
            return;
        }
        this.destroyChildren();
        this.enclosedPage_ = page;
        this.history_.addPage(page);
        if (this.isJavaScriptInitializationNeeded()) {
            this.webClient_.initialize(this);
        }
        this.webClient_.initialize(page);
    }

    protected abstract boolean isJavaScriptInitializationNeeded();

    public void setScriptObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    public Object getScriptObject() {
        return this.scriptObject_;
    }

    public JavaScriptJobManager getJobManager() {
        return this.jobManager_;
    }

    public void setJobManager(JavaScriptJobManager jobManager) {
        this.jobManager_ = jobManager;
    }

    public void addChildWindow(FrameWindow child) {
        this.childWindows_.add(child);
    }

    void destroyChildren() {
        LOG.debug((Object)"destroyChildren");
        this.getJobManager().removeAllJobs();
        ListIterator<WebWindowImpl> iter = this.childWindows_.listIterator();
        while (iter.hasNext()) {
            WebWindowImpl window = iter.next();
            LOG.debug((Object)("closing child window: " + window));
            window.setClosed();
            window.getJobManager().shutdown();
            Page page = window.getEnclosedPage();
            if (page instanceof HtmlPage) {
                ((HtmlPage)page).cleanUp();
            }
            window.destroyChildren();
            iter.remove();
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public History getHistory() {
        return this.history_;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    protected void setClosed() {
        this.closed_ = true;
    }
}

