/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.AssertionResult;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.EntryResult;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assertion {
    private String id;
    private String entryType;
    private String type;
    private List<String> prereqs;
    private String failureMessage;
    private String failureDetailDescription;

    public Assertion(Element el) {
        this.id = el.getAttribute("id");
        this.entryType = el.getAttribute("entryType");
        this.type = el.getAttribute("type");
        this.prereqs = new ArrayList<String>();
        NodeList prereqNL = el.getElementsByTagNameNS("http://www.ws-i.org/testing/2004/07/assertions/", "testAssertionID");
        int i = 0;
        while (i < prereqNL.getLength()) {
            CharacterData prereqNode = (CharacterData)prereqNL.item(i).getFirstChild();
            this.prereqs.add(prereqNode.getData().trim());
            ++i;
        }
        Element failureMessageEl = (Element)el.getElementsByTagNameNS("http://www.ws-i.org/testing/2004/07/assertions/", "failureMessage").item(0);
        if (failureMessageEl.getChildNodes().getLength() > 0) {
            this.failureMessage = ((CharacterData)failureMessageEl.getFirstChild()).getData().trim();
        }
    }

    public AssertionResult runTest(Entry e) throws ValidatorException {
        if (this.isApplicable(e)) {
            if (this.applyRule(e)) {
                return new AssertionResult(this.id, AssertionResult.Result.PASSED);
            }
            if (this.type.equals("recommended")) {
                return new AssertionResult(this.id, AssertionResult.Result.WARNING);
            }
            return new AssertionResult(this.id, AssertionResult.Result.FAILED);
        }
        return new AssertionResult(this.id, AssertionResult.Result.NOT_APPLICABLE);
    }

    public boolean matchesEntryType(String comparison) {
        return comparison.equals(this.entryType);
    }

    public String getEntryType() {
        return this.entryType;
    }

    public List<String> getPrereqs() {
        return this.prereqs;
    }

    public String getId() {
        return this.id;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getFailureDetailDescription() {
        return this.failureDetailDescription;
    }

    public boolean anyPrereqFailed(EntryResult results) {
        for (String prereq : this.getPrereqs()) {
            if (results.getAssertionResult(prereq) == null || !results.getAssertionResult(prereq).failed()) continue;
            return true;
        }
        return false;
    }

    public boolean allPrereqsPassed(EntryResult results) {
        for (String prereq : this.getPrereqs()) {
            if (results.getAssertionResult(prereq) != null && !results.getAssertionResult(prereq).failed()) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isApplicable(Entry var1) throws ValidatorException;

    protected abstract boolean applyRule(Entry var1) throws ValidatorException;
}

