/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private List<String> noArgOptions;
    private List<String> oneArgOptions;
    private Map<String, String> results;

    public CommandLineParser(List<String> noargs, List<String> onearg) {
        this.noArgOptions = noargs == null ? new ArrayList<String>() : noargs;
        this.oneArgOptions = onearg == null ? new ArrayList<String>() : onearg;
    }

    public void parseArgs(String[] args) throws ValidatorException {
        if (this.results != null) {
            throw new ValidatorException("Arguments already parsed");
        }
        this.results = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            String thisOption = args[i];
            if (thisOption.charAt(0) != '-') {
                throw new ValidatorException("Error parsing command line args");
            }
            if (this.noArgOptions.contains(thisOption = thisOption.substring(1))) {
                ++i;
                this.results.put(thisOption, "true");
                continue;
            }
            if (this.oneArgOptions.contains(thisOption)) {
                String optVal = args[++i];
                ++i;
                this.results.put(thisOption, optVal);
                continue;
            }
            throw new ValidatorException("Unknown argument: " + thisOption);
        }
    }

    private boolean isKnownOption(String option) {
        return this.noArgOptions.contains(option) || this.oneArgOptions.contains(option);
    }

    public String getOption(String option) throws ValidatorException {
        if (this.results == null) {
            throw new ValidatorException("No arguments parsed yet");
        }
        if (this.results.containsKey(option)) {
            return this.results.get(option);
        }
        if (!this.isKnownOption(option)) {
            throw new ValidatorException("Unknown command line option: " + option);
        }
        return null;
    }
}

