/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.AssertionResult;
import org.wsi.test.validator.EntryResult;
import org.wsi.test.validator.ValidatorException;

public abstract class Entry {
    protected Element element;

    public Entry(Element el) {
        this.element = el;
    }

    public EntryResult validate(Artifact artifact, String id) throws ValidatorException {
        EntryResult result = this.getEntryResultInstance(this, id);
        ArrayList<Assertion> bucket = new ArrayList<Assertion>();
        bucket.addAll(artifact.getAssertions());
        ArrayList<Assertion> removeList = new ArrayList<Assertion>();
        for (Assertion a : bucket) {
            if (a.matchesEntryType(this.getEntryTypeTag())) continue;
            removeList.add(a);
        }
        bucket.removeAll(removeList);
        while (!bucket.isEmpty()) {
            removeList = new ArrayList();
            for (Assertion a : bucket) {
                if (a.anyPrereqFailed(result)) {
                    removeList.add(a);
                    result.addAssertionResult(new AssertionResult(a.getId(), AssertionResult.Result.PREREQ_FAILED));
                    continue;
                }
                if (!a.allPrereqsPassed(result)) continue;
                removeList.add(a);
                result.addAssertionResult(this.runTest(a));
            }
            if (removeList.isEmpty()) {
                throw new ValidatorException("Prereq dependency loop detected");
            }
            bucket.removeAll(removeList);
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public String getXMLString() throws ValidatorException {
        DOMSource s = new DOMSource(this.element);
        StringWriter resultWriter = null;
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            resultWriter = new StringWriter();
            StreamResult result = new StreamResult(resultWriter);
            t.setOutputProperty("indent", "yes");
            t.transform(s, result);
        }
        catch (Exception e) {
            throw new ValidatorException(e);
        }
        String xmlString = resultWriter.toString();
        return xmlString.split("\n", 2)[1];
    }

    private AssertionResult runTest(Assertion a) throws ValidatorException {
        return a.runTest(this);
    }

    public abstract String getEntryTypeTag();

    protected abstract EntryResult getEntryResultInstance(Entry var1, String var2);
}

