/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.test.validator.AssertionResult;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryResult {
    private List<AssertionResult> assertionResults = new ArrayList<AssertionResult>();
    private Entry entry;
    private String messageIdNum;
    private static Map<String, Integer> currentIds = new Hashtable<String, Integer>();
    private String savedId;

    public EntryResult(Entry e, String id) {
        this.entry = e;
        this.messageIdNum = id;
    }

    public void addAssertionResult(AssertionResult r) {
        this.assertionResults.add(r);
    }

    public List<AssertionResult> getAssertionResults() {
        return this.assertionResults;
    }

    public AssertionResult getAssertionResult(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id)) continue;
            return r;
        }
        return null;
    }

    public List<String> getReportedIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (AssertionResult r : this.assertionResults) {
            ids.add(r.getAssertionId());
        }
        return ids;
    }

    public boolean anyFailed(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id) || !r.getResult().equals((Object)AssertionResult.Result.FAILED)) continue;
            return true;
        }
        return false;
    }

    public boolean anyWarnings(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id) || !r.getResult().equals((Object)AssertionResult.Result.WARNING)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPassed(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id) || !r.getResult().equals((Object)AssertionResult.Result.PASSED)) continue;
            return true;
        }
        return false;
    }

    public boolean allNotApplicable(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id) || r.getResult().equals((Object)AssertionResult.Result.NOT_APPLICABLE)) continue;
            return false;
        }
        return true;
    }

    public boolean anyNotApplicable(String id) {
        for (AssertionResult r : this.assertionResults) {
            if (!r.getAssertionId().equals(id) || !r.getResult().equals((Object)AssertionResult.Result.NOT_APPLICABLE)) continue;
            return true;
        }
        return false;
    }

    public Element getReportElement(Document doc, String reportNamespace, Configuration config) throws ValidatorException {
        Element reportElement = doc.createElementNS(reportNamespace, "entry");
        reportElement.setAttribute("type", this.entry.getEntryTypeTag());
        reportElement.setAttribute("referenceID", this.getReferenceId());
        if (config.getAssertionResultsMessageEntry()) {
            reportElement.setAttribute("value", this.entry.getXMLString());
        }
        for (AssertionResult r : this.assertionResults) {
            if (!config.shouldReport(r)) continue;
            reportElement.appendChild(r.getReportElement(doc, reportNamespace, config));
        }
        return reportElement;
    }

    protected String getReferenceId() {
        if (this.savedId != null) {
            return this.savedId;
        }
        if (!currentIds.containsKey(this.entry.getEntryTypeTag())) {
            currentIds.put(this.entry.getEntryTypeTag(), new Integer(1));
        } else {
            currentIds.put(this.entry.getEntryTypeTag(), new Integer(currentIds.get(this.entry.getEntryTypeTag()) + 1));
        }
        String id = null;
        id = "message_" + this.messageIdNum;
        id = String.valueOf(id) + "-" + this.entry.getEntryTypeTag();
        this.savedId = id = String.valueOf(id) + "-" + this.getUniqueIdString();
        return id;
    }

    protected String getUniqueIdString() {
        String idString = this.getIdAttribute();
        if (idString != null) {
            return idString;
        }
        idString = currentIds.get(this.entry.getEntryTypeTag()).toString();
        return idString;
    }

    protected Entry getEntry() {
        return this.entry;
    }

    protected String getIdAttribute() {
        if (this.entry.getElement().hasAttribute("Id")) {
            return this.entry.getElement().getAttribute("Id");
        }
        return null;
    }
}

