/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.wsi.test.validator.ArtifactResult;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    private List<ArtifactResult> results = new ArrayList<ArtifactResult>();
    private Configuration config;
    private String title;
    private String reportNamespace;
    private String version;
    private String date;
    private Throwable analyzerFailure;

    public Report(Configuration c, String t, String ns, String v, String d) {
        this.config = c;
        this.title = t;
        this.reportNamespace = ns;
        this.version = v;
        this.date = d;
    }

    public void addArtifactResult(ArtifactResult r) {
        this.results.add(r);
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public List<String> getReportedIds() {
        HashSet<String> ids = new HashSet<String>();
        for (ArtifactResult r : this.results) {
            ids.addAll(r.getReportedIds());
        }
        return new ArrayList<String>(ids);
    }

    public boolean anyFailed(String id) throws ValidatorException {
        if (this.prereqFailed(id)) {
            return false;
        }
        for (ArtifactResult r : this.results) {
            if (!r.anyFailed(id)) continue;
            return true;
        }
        return false;
    }

    public boolean anyWarnings(String id) throws ValidatorException {
        if (this.prereqFailed(id)) {
            return false;
        }
        for (ArtifactResult r : this.results) {
            if (!r.anyWarnings(id)) continue;
            return true;
        }
        return false;
    }

    public boolean anyFailed() throws ValidatorException {
        for (String id : this.getReportedIds()) {
            if (!this.anyFailed(id)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPassed(String id) {
        for (ArtifactResult r : this.results) {
            if (!r.anyPassed(id)) continue;
            return true;
        }
        return false;
    }

    public boolean allNotApplicable(String id) {
        for (ArtifactResult r : this.results) {
            if (r.allNotApplicable(id)) continue;
            return false;
        }
        return true;
    }

    public boolean anyNotApplicable(String id) {
        for (ArtifactResult r : this.results) {
            if (!r.anyNotApplicable(id)) continue;
            return true;
        }
        return false;
    }

    public boolean atLeastOnePassNoFails(String id) throws ValidatorException {
        return this.anyPassed(id) && !this.anyFailed(id);
    }

    public void reportAnalyzerFailure(Throwable t) {
        this.analyzerFailure = t;
    }

    public boolean analyzerFailed() {
        return this.analyzerFailure != null;
    }

    private boolean prereqFailed(String id) throws ValidatorException {
        Assertion assertion = this.config.getTad().getAssertion(id);
        if (assertion == null) {
            return false;
        }
        List<String> prereqIds = assertion.getPrereqs();
        for (String prereqId : prereqIds) {
            if (!this.anyFailed(prereqId)) continue;
            return true;
        }
        return false;
    }

    private Element getAnalyzerElement(Document doc) {
        Element el = doc.createElementNS(this.reportNamespace, "analyzer");
        el.setAttribute("version", this.version);
        el.setAttribute("releaseDate", this.date);
        Element implementer = doc.createElementNS(this.reportNamespace, "implementer");
        implementer.setAttribute("name", "IBM");
        implementer.setAttribute("location", "http://ibm.com");
        el.appendChild(implementer);
        Element environment = doc.createElementNS(this.reportNamespace, "environment");
        Element runtime = doc.createElementNS(this.reportNamespace, "runtime");
        runtime.setAttribute("name", System.getProperty("java.runtime.name"));
        runtime.setAttribute("version", System.getProperty("java.runtime.version"));
        environment.appendChild(runtime);
        Element operatingSystem = doc.createElementNS(this.reportNamespace, "operatingSystem");
        operatingSystem.setAttribute("name", System.getProperty("os.name"));
        operatingSystem.setAttribute("version", System.getProperty("os.version"));
        environment.appendChild(operatingSystem);
        Element xmlParser = doc.createElementNS(this.reportNamespace, "xmlParser");
        xmlParser.setAttribute("name", "unknown");
        xmlParser.setAttribute("version", "unknown");
        environment.appendChild(xmlParser);
        el.appendChild(environment);
        Element configuration = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "configuration");
        el.appendChild(configuration);
        Element verbose = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "verbose");
        verbose.appendChild(doc.createTextNode(Boolean.toString(this.config.getVerbose())));
        configuration.appendChild(verbose);
        Element assertionResults = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "assertionResults");
        assertionResults.setAttribute("type", this.config.getAssertionResultsType().getName());
        assertionResults.setAttribute("messageEntry", Boolean.toString(this.config.getAssertionResultsMessageEntry()));
        assertionResults.setAttribute("assertionDescription", Boolean.toString(this.config.getAssertionDescription()));
        assertionResults.setAttribute("failureMessage", Boolean.toString(this.config.getAssertionResultsFailureMessage()));
        assertionResults.setAttribute("failureDetail", Boolean.toString(this.config.getAssertionResultsFailureDetails()));
        configuration.appendChild(assertionResults);
        Element reportFile = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "reportFile");
        reportFile.setAttribute("replace", Boolean.toString(this.config.getReportFileReplace()));
        reportFile.setAttribute("location", this.config.getReportFileLocation());
        configuration.appendChild(reportFile);
        Element addStyleSheet = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "addStyleSheet");
        addStyleSheet.setAttribute("href", this.config.getStyleSheetHref());
        addStyleSheet.setAttribute("type", this.config.getStyleSheetType());
        reportFile.appendChild(addStyleSheet);
        Element testAssertionsFile = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "testAssertionsFile");
        testAssertionsFile.appendChild(doc.createTextNode(this.config.getTadLocation()));
        configuration.appendChild(testAssertionsFile);
        Element logFile = doc.createElementNS("http://www.ws-i.org/testing/2004/07/analyzerConfig/", "logFile");
        logFile.setAttribute("correlationType", this.config.getLogFileCorrelationType());
        logFile.appendChild(doc.createTextNode(this.config.getLogFileLocation()));
        configuration.appendChild(logFile);
        return el;
    }

    public Document getReport() throws ValidatorException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ValidatorException(e);
        }
        Document doc = builder.newDocument();
        Element el = doc.createElementNS(this.reportNamespace, "report");
        el.setAttribute("name", this.title);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        el.setAttribute("timestamp", dateFormat.format(new Date()));
        el.appendChild(this.getAnalyzerElement(doc));
        if (this.analyzerFailure == null) {
            for (ArtifactResult r : this.getResults()) {
                el.appendChild(r.getReportElement(doc, this.reportNamespace, this.config));
            }
            Element summary = doc.createElementNS(this.reportNamespace, "summary");
            if (this.anyFailed()) {
                summary.setAttribute("result", "failed");
            } else {
                summary.setAttribute("result", "passed");
            }
            el.appendChild(summary);
        } else {
            Element failure = doc.createElementNS(this.reportNamespace, "analyzerFailure");
            Element failureDetail = doc.createElementNS(this.reportNamespace, "failureDetail");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream errorStream = new PrintStream(baos);
            errorStream.append(String.valueOf(this.analyzerFailure.getMessage()) + "\n");
            this.analyzerFailure.printStackTrace(errorStream);
            failureDetail.appendChild(doc.createTextNode(baos.toString()));
            failure.appendChild(failureDetail);
            el.appendChild(failure);
        }
        doc.appendChild(el);
        Element docEl = doc.getDocumentElement();
        if (this.config.getStyleSheetHref() == null) {
            Comment comment = doc.createComment("?xml-stylesheet type=\"text/xsl\" href=\"../common/xsl/report.xsl\"?");
            docEl.getParentNode().insertBefore(comment, docEl);
        } else {
            ProcessingInstruction pInst = doc.createProcessingInstruction("xml-stylesheet", "href=\"" + this.config.getStyleSheetHref() + "\" type=\"" + this.config.getStyleSheetType() + "\"");
            docEl.getParentNode().insertBefore(pInst, docEl);
        }
        return doc;
    }
}

