/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class FitScrollPane
extends JScrollPane
implements ComponentListener {
    public FitScrollPane() {
        this.initScrollPane();
    }

    public FitScrollPane(Component view) {
        super(view);
        this.initScrollPane();
    }

    public FitScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.initScrollPane();
    }

    public FitScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.initScrollPane();
    }

    private void initScrollPane() {
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.getViewport().getView().addComponentListener(this);
        this.removeMouseWheelListeners();
    }

    private void removeMouseWheelListeners() {
        MouseWheelListener[] listeners = this.getMouseWheelListeners();
        for (int i = 0; i < listeners.length; ++i) {
            MouseWheelListener listener = listeners[i];
            this.removeMouseWheelListener(listener);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.removeMouseWheelListeners();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize(this.getSize().width, this.getPreferredSize().height);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getViewport() != null && this.getViewport().getView() != null) {
            this.getViewport().setPreferredSize(this.getViewport().getView().getPreferredSize());
        }
        return super.getPreferredSize();
    }
}

