/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog;

import com.jidesoft.swing.JideScrollPane;
import hermes.browser.HermesBrowser;
import hermes.browser.components.ClasspathGroupTable;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.ClasspathGroupTableModel;
import hermes.config.HermesConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Category;

public class ProviderConfigPanel
extends JPanel {
    private static final Category cat = Category.getInstance(ProviderConfigPanel.class);
    private static File lastDirectory = null;
    private PreferencesDialog dialog;
    private ClasspathGroupTable table;
    private ClasspathGroupTableModel model;
    private HermesConfig hermesConfig;
    private JLabel topLabel = new JLabel();
    private JideScrollPane tableSP = new JideScrollPane();
    private boolean modelChanged = false;

    public ProviderConfigPanel(PreferencesDialog dialog) {
        this.dialog = dialog;
        this.init();
    }

    private void init() {
        Border border = BorderFactory.createBevelBorder(0);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        topPanel.setLayout(new GridLayout(1, 2));
        this.topLabel.setText("ClasspathGroups containing JMS providers and dependent libraries.");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(border, "ClasspathGroups"));
        topPanel.add(this.topLabel);
        this.add((Component)topPanel, "North");
        this.add((Component)this.tableSP, "Center");
        this.add((Component)new JLabel(), "South");
    }

    public boolean isModelChanged() {
        return this.modelChanged;
    }

    public void setHermesConfig(HermesConfig hermesConfig) {
        this.hermesConfig = hermesConfig;
        try {
            this.model = new ClasspathGroupTableModel(this.dialog, HermesBrowser.getConfigDAO().duplicateClasspathGroups(hermesConfig.getClasspathGroup()));
            if (this.table == null) {
                this.table = new ClasspathGroupTable(this.dialog, this.model);
                this.tableSP.setViewportView((Component)((Object)this.table));
                this.tableSP.addMouseListener((MouseListener)this.table.getMouseAdapter());
            } else {
                this.table.setModel(this.model);
            }
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent evt) {
                    if (evt.getType() == 1 || evt.getType() == 0) {
                        ProviderConfigPanel.this.modelChanged = true;
                    }
                }
            });
        }
        catch (JAXBException e) {
            cat.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void updateModel() {
        this.hermesConfig.getClasspathGroup().clear();
        this.hermesConfig.getClasspathGroup().addAll(this.model.getRows());
        this.modelChanged = false;
    }
}

