/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.jython;

import com.artenum.jyconsole.JyConsole;
import hermes.Hermes;
import hermes.SystemProperties;
import hermes.browser.HermesBrowser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;

public class JythonManager {
    private static final Logger log = Logger.getLogger(JythonManager.class);
    private JyConsole jyConsole = new JyConsole();

    public JythonManager() {
        this.init();
    }

    public PythonInterpreter getInterpreter() {
        return this.jyConsole.getPythonInterpreter();
    }

    public JyConsole getConsole() {
        return this.jyConsole;
    }

    public void exec(String info, InputStream istream) {
        try {
            this.getInterpreter().execfile(istream);
        }
        catch (PyException ex) {
            HermesBrowser.getBrowser().getDefaultMessageSink().add("Error " + info + ": " + ex.getMessage());
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().getDefaultMessageSink().add("Error " + info + ": " + ex.getMessage());
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void init() {
        log.debug((Object)"bootstraping jython...");
        this.exec("Bootstrapping Jython", this.getClass().getResourceAsStream("bootstrap.py"));
        File bootstrapFile = new File(System.getProperty("user.home") + SystemProperties.FILE_SEPARATOR + ".hermes" + SystemProperties.FILE_SEPARATOR + "hermesrc.py");
        if (bootstrapFile.exists()) {
            try {
                log.debug((Object)("reading " + bootstrapFile.getName()));
                this.exec("Reading hermesrc.py", new FileInputStream(bootstrapFile));
                Hermes.ui.getDefaultMessageSink().add("Loaded hermesrc.py");
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug((Object)("Unable to locate a hermesrc.py in " + System.getProperty("user.home")));
        }
        try {
            if (System.getProperty("hermes.python.url") != null) {
                String url = System.getProperty("hermes.python.url");
                log.debug((Object)("reading " + url));
                this.exec("Reading " + url, new URL(url).openStream());
            } else {
                log.debug((Object)"no hermes.python.url set");
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog(ex);
        }
    }
}

