/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.util.TextUtils;
import java.io.StringWriter;

public class DumpUtils {
    public static final int DUMP_AS_HEX = 1;
    public static final int DUMP_AS_ALPHA = 2;
    public static final int DUMP_AS_STRING = 3;
    public static final int DUMP_AS_HEX_AND_ALPHA = 4;
    public static final int ROW_LEN = 16;

    public static String dumpBinary(byte[] data, int mode) {
        int maxSize = 0x500000;
        return mode == 3 ? TextUtils.toAsciiString(data) : DumpUtils.dumpBinaryEx(data, mode, maxSize);
    }

    private static String dumpBinaryEx(byte[] data, int mode, int maxSize) {
        StringWriter b = new StringWriter();
        int c = 0;
        if (data != null) {
            while (c < data.length) {
                int max = Math.min(16, data.length - c);
                byte[] row = new byte[max];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = data[c + i];
                }
                switch (mode) {
                    case 2: {
                        DumpUtils.dumpBinaryLineAsAlpha(b, c, row);
                        break;
                    }
                    case 1: {
                        DumpUtils.dumpBinaryLineAsHex(b, c, row);
                        break;
                    }
                    case 4: {
                        DumpUtils.dumpBinaryLineAsHexAndAlpha(b, c, row);
                    }
                }
                if ((c += 16) <= maxSize) continue;
                b.append("Message too big");
                break;
            }
        } else {
            b.append("No payload.");
        }
        return b.toString();
    }

    public static void dumpBinaryLineAsHexAndAlpha(StringWriter b, long offset, byte[] data) {
        b.append(TextUtils.leftPadLong(offset, 8));
        b.append(" - ");
        b.append(TextUtils.leftAlign(TextUtils.toHexString(data, true), 48));
        b.append(" - ");
        b.append(TextUtils.toAsciiString(data));
        b.append("\r\n");
    }

    public static void dumpBinaryLineAsHex(StringWriter b, long offset, byte[] data) {
        b.append(TextUtils.leftPadLong(offset, 8));
        b.append(" - ");
        b.append(TextUtils.toHexString(data, true));
        b.append("\r\n");
    }

    public static void dumpBinaryLineAsAlpha(StringWriter b, long offset, byte[] data) {
        b.append(TextUtils.leftPadLong(offset, 8));
        b.append(" - ");
        b.append(TextUtils.toAsciiString(data));
        b.append("\r\n");
    }

    public static void dumpBinaryLineAsHexAndEBCDIC(StringWriter b, long offset, char[] mappings, byte[] data, int rowLen) {
        b.append(TextUtils.leftPadLong(offset, 8));
        b.append(" - ");
        b.append(TextUtils.leftAlign(TextUtils.toHexString(data, true), rowLen * 3));
        b.append(" - ");
        b.append(DumpUtils.EBCDICtoASCII(mappings, data));
        b.append("\r\n");
    }

    public static String EBCDICtoASCII(char[] mappings, byte[] data) {
        StringBuffer messageBuffer = new StringBuffer();
        for (int j = 0; j < data.length; ++j) {
            int n = data[j];
            if (n < 0) {
                n = 256 + n;
            }
            messageBuffer.append(mappings[n]);
        }
        return messageBuffer.toString();
    }
}

