/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.autoupdate;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.autoupdate.NewSoapUIVersionAvailableDialog;
import com.eviware.soapui.autoupdate.SoapUIUpdateProvider;
import com.eviware.soapui.autoupdate.SoapUIVersionInfo;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.settings.VersionUpdateSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Install4jSoapUIUpdateProvider
extends Thread
implements SoapUIUpdateProvider {
    private static final String APPLICATION_SILENT_VERSION_CHECK_ID = "4969";
    private static final String APPLICATION_UPDATES_XML_URL = "http://dl.eviware.com/version-update/soapui-updates-os.xml";
    private static final String DEFAULT_UNREACHABLE_VALUE_FOR_SKIPPED_VERSION = "-1";
    private final String TERMINATED = "Terminated {EE9BF704-944A-43ae-8B53-7C9AE5SOAPUI}";
    private static final Logger logger = LoggerFactory.getLogger(SoapUIUpdateProvider.class);
    private static final String NEXT_AUTO_UPDATE_CHECK = "NextAU";
    private final TestMonitor testMonitor;
    private final String currentVersion;
    private volatile boolean autoCheckCancelled = false;

    public Install4jSoapUIUpdateProvider(String soapuiVersion, TestMonitor testMonitor) {
        this.testMonitor = testMonitor;
        this.currentVersion = soapuiVersion;
    }

    @Override
    public void showUpdateStatus() {
        this.autoCheckCancelled = true;
        final XProgressDialog waitDialog = UISupport.getDialogs().createProgressDialog("Checking for update", 100, "Update is checking...", true);
        try {
            waitDialog.run(new Worker(){
                private UpdateCheckResult result;
                private boolean cancelled = false;

                @Override
                public Object construct(XProgressMonitor monitor) {
                    String error = Install4jSoapUIUpdateProvider.this.checkURLisReachable(Install4jSoapUIUpdateProvider.APPLICATION_UPDATES_XML_URL);
                    this.result = StringUtils.isNullOrEmpty(error) || this.cancelled ? Install4jSoapUIUpdateProvider.this.checkUpdate() : UpdateCheckResult.error(error);
                    return null;
                }

                @Override
                public void finished() {
                    if (this.cancelled) {
                        return;
                    }
                    waitDialog.setVisible(false);
                    if (StringUtils.hasContent(this.result.errorText)) {
                        if (!"Terminated {EE9BF704-944A-43ae-8B53-7C9AE5SOAPUI}".equals(this.result.errorText)) {
                            UISupport.showErrorMessage(this.result.errorText);
                        }
                    } else if (this.result.version == null) {
                        UISupport.showInfoMessage("You are using the latest accessible release of SoapUI");
                    } else if (!Install4jSoapUIUpdateProvider.this.updatePostponedByUser(this.result.version, new SoapUIVersionInfo(Install4jSoapUIUpdateProvider.this.currentVersion), this.result.comments)) {
                        Install4jSoapUIUpdateProvider.this.update(false);
                    }
                }

                @Override
                public boolean onCancel() {
                    this.cancelled = true;
                    waitDialog.setVisible(false);
                    return true;
                }
            });
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e.getMessage());
        }
    }

    private boolean update(boolean blocking) {
        try {
            ApplicationLauncher.launchApplication((String)APPLICATION_SILENT_VERSION_CHECK_ID, null, (boolean)blocking, (ApplicationLauncher.Callback)new ApplicationLauncher.Callback(){

                public void exited(int i) {
                }

                public void prepareShutdown() {
                    if (Install4jSoapUIUpdateProvider.this.testMonitor.hasRunningTests()) {
                        Install4jSoapUIUpdateProvider.this.testMonitor.cancelAllTests("Terminated because of auto-update.");
                    }
                    Install4jSoapUIUpdateProvider.this.DoExit();
                }
            });
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    private void DoExit() {
        try {
            SoapUI.saveSettings();
            SaveStatus saveStatus = SoapUI.getWorkspace().onClose();
            if (saveStatus == SaveStatus.CANCELLED || saveStatus == SaveStatus.FAILED) {
                return;
            }
        }
        catch (Exception e1) {
            logger.error("Error saving settings during exit", (Throwable)e1);
        }
        SoapUI.shutdown();
    }

    @Override
    public void run() {
        Date now = new Date();
        Date whenCheck = new Date(SoapUI.getSettings().getLong(NEXT_AUTO_UPDATE_CHECK, now.getTime()));
        if (!now.before(whenCheck)) {
            String error = this.checkURLisReachable(APPLICATION_UPDATES_XML_URL);
            if (StringUtils.hasContent(error)) {
                logger.info(error);
            } else {
                String skippedVersion;
                UpdateCheckResult checkResult = this.checkUpdate();
                if (StringUtils.hasContent(checkResult.errorText)) {
                    logger.info(checkResult.errorText);
                    return;
                }
                if (checkResult.version != null && (skippedVersion = SoapUI.getSettings().getString("SkippedVersion", DEFAULT_UNREACHABLE_VALUE_FOR_SKIPPED_VERSION)) != null && skippedVersion.equals(checkResult.version.toString())) {
                    logger.info("Found new version (" + skippedVersion + ") but it was skipped according to previous user's choice.");
                    return;
                }
                if (checkResult.version != null && !this.autoCheckCancelled && !this.updatePostponedByUser(checkResult.version, new SoapUIVersionInfo(this.currentVersion), checkResult.comments)) {
                    this.update(true);
                }
            }
        }
    }

    private NewSoapUIVersionAvailableDialog.ReadyApiUpdateDialogResult showUpdateIsAvailableDialog(SoapUIVersionInfo newVersion, SoapUIVersionInfo curVersion, String comments) {
        NewSoapUIVersionAvailableDialog dialog = new NewSoapUIVersionAvailableDialog(newVersion, curVersion, comments);
        return dialog.showDialog();
    }

    private boolean updatePostponedByUser(SoapUIVersionInfo newVersion, SoapUIVersionInfo curVersion, String comments) {
        long A_DAY = 86400000L;
        boolean result = true;
        Date nextCheck = null;
        switch (this.showUpdateIsAvailableDialog(newVersion, curVersion, comments)) {
            case Update: {
                if (SoapUI.getSettings().getBoolean(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE)) {
                    nextCheck = new Date();
                }
                result = false;
                break;
            }
            case Delay_1Day: {
                nextCheck = new Date(new Date().getTime() + 86400000L);
                break;
            }
            case Delay_3Days: {
                nextCheck = new Date(new Date().getTime() + 259200000L);
                break;
            }
            case Delay_7Days: {
                nextCheck = new Date(new Date().getTime() + 604800000L);
                break;
            }
            case DoNotUpdate: {
                break;
            }
        }
        if (nextCheck != null) {
            SoapUI.getSettings().setLong(NEXT_AUTO_UPDATE_CHECK, nextCheck.getTime());
            SoapUI.getSettings().setBoolean(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE, true);
        }
        return result;
    }

    private String checkURLisReachable(String url) {
        try {
            int timeout = 10000;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            int responseCode = connection.getResponseCode();
            if (200 <= responseCode && responseCode <= 399) {
                return null;
            }
            return String.format("The update server is unreachable: The attempt to connect to the update server has resulted in %d code.", responseCode);
        }
        catch (IOException exception) {
            return String.format("The update server is unreachable: %s", exception.getMessage());
        }
    }

    private UpdateCheckResult checkUpdate() {
        SoapUIVersionInfo newVersionObj;
        SoapUIVersionInfo currentVersionObj;
        String newVersion = null;
        UpdateDescriptorEntry entry = null;
        try {
            UpdateDescriptor descriptor = this.getUpdateDescriptor();
            if (descriptor != null && (entry = descriptor.getPossibleUpdateEntry()) != null) {
                newVersion = entry.getNewVersion();
            }
        }
        catch (UserCanceledException ex) {
            return UpdateCheckResult.error("Terminated {EE9BF704-944A-43ae-8B53-7C9AE5SOAPUI}");
        }
        catch (IOException ex) {
            return UpdateCheckResult.error(ex.getMessage());
        }
        if (newVersion != null && newVersion.length() != 0 && (currentVersionObj = new SoapUIVersionInfo(this.currentVersion)).compare(currentVersionObj, newVersionObj = new SoapUIVersionInfo(newVersion)) < 0) {
            return UpdateCheckResult.found(newVersionObj, entry.getComment());
        }
        return UpdateCheckResult.noUpdate();
    }

    private UpdateDescriptor getUpdateDescriptor() throws UserCanceledException, IOException {
        return UpdateChecker.getUpdateDescriptor((String)APPLICATION_UPDATES_XML_URL, (ApplicationDisplayMode)ApplicationDisplayMode.GUI);
    }

    private static class UpdateCheckResult {
        public SoapUIVersionInfo version = null;
        public String comments = null;
        public String errorText = null;

        private UpdateCheckResult() {
        }

        public static UpdateCheckResult error(String errorText) {
            UpdateCheckResult result = new UpdateCheckResult();
            result.errorText = errorText;
            return result;
        }

        public static UpdateCheckResult found(SoapUIVersionInfo version, String comments) {
            UpdateCheckResult result = new UpdateCheckResult();
            result.version = version;
            result.comments = comments;
            return result;
        }

        public static UpdateCheckResult noUpdate() {
            return new UpdateCheckResult();
        }
    }
}

