/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.autoupdate;

import java.util.Comparator;

public class SoapUIVersionInfo
implements Comparator<SoapUIVersionInfo> {
    private int majorVersion;
    private int minorVersion;
    private int middleVersion;
    private String asString;

    public SoapUIVersionInfo(int majorVersion, int middleVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.middleVersion = middleVersion;
        this.minorVersion = minorVersion;
        this.asString = String.format("%d.%d.%d", majorVersion, minorVersion, middleVersion);
    }

    public SoapUIVersionInfo(String version) {
        this.asString = version;
        String[] versionParts = version.split("\\.");
        try {
            this.majorVersion = Integer.parseInt(versionParts[0]);
        }
        catch (NumberFormatException ex) {
            this.majorVersion = 0;
        }
        try {
            this.middleVersion = Integer.parseInt(versionParts[1]);
        }
        catch (NumberFormatException ex) {
            this.middleVersion = 0;
        }
        try {
            this.minorVersion = Integer.parseInt(versionParts[2]);
        }
        catch (NumberFormatException ex) {
            this.minorVersion = 0;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMiddleVersion() {
        return this.middleVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int compare(SoapUIVersionInfo o1, SoapUIVersionInfo o2) {
        if (o1.getMajorVersion() < o2.getMajorVersion()) {
            return -1;
        }
        if (o1.getMajorVersion() > o2.getMajorVersion()) {
            return 1;
        }
        if (o1.getMiddleVersion() < o2.getMiddleVersion()) {
            return -1;
        }
        if (o1.getMiddleVersion() > o2.getMiddleVersion()) {
            return 1;
        }
        if (o1.getMinorVersion() < o2.getMinorVersion()) {
            return -1;
        }
        if (o1.getMinorVersion() > o2.getMinorVersion()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        SoapUIVersionInfo ver = (SoapUIVersionInfo)obj;
        if (ver == null) {
            return false;
        }
        return this.getMajorVersion() == ver.getMajorVersion() && this.getMiddleVersion() == ver.getMiddleVersion() && this.getMinorVersion() == ver.getMinorVersion();
    }

    public String toString() {
        return this.asString;
    }
}

