/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.JTextFieldFormField;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;

public class RestUriDialogHandler {
    private KeyListener initialKeyListener;
    private MouseListener initialMouseListener;
    private Font originalFont;
    private boolean defaultURIReplaced;
    private JUndoableTextField textField;
    private XFormDialog dialog;
    private String uriLabelKey;
    private String exampleUri;

    public XFormDialog buildDialog(MessageSupport messages) {
        return this.buildDialog(messages, "/REST-Testing/getting-started.html", null);
    }

    public XFormDialog buildDialog(MessageSupport messages, AbstractAction actionToBeAdded) {
        return this.buildDialog(messages, "/REST-Testing/getting-started.html", actionToBeAdded);
    }

    public XFormDialog buildDialog(MessageSupport messages, String helpUrl) {
        return this.buildDialog(messages, helpUrl, null);
    }

    public XFormDialog buildDialog(MessageSupport messages, String helpUrl, AbstractAction actionToBeAdded) {
        XFormDialogBuilder newDialogBuilder = XFormFactory.createDialogBuilder(messages.get("Title"));
        XForm form = newDialogBuilder.createForm("");
        this.uriLabelKey = messages.get("Form.URI.Label");
        this.exampleUri = messages.get("Form.Example.URI");
        form.addTextField(this.uriLabelKey, messages.get("Form.URI.Description"), XForm.FieldType.TEXT);
        ActionList actions = newDialogBuilder.buildOkCancelHelpActions(helpUrl);
        if (actionToBeAdded != null) {
            actions.addAction(actionToBeAdded);
        }
        this.dialog = newDialogBuilder.buildDialog(actions, messages.get("Description"), UISupport.TOOL_ICON);
        this.dialog.setValue(this.uriLabelKey, this.exampleUri);
        XFormField uriField = this.dialog.getFormField(this.uriLabelKey);
        if (uriField instanceof JTextFieldFormField) {
            this.defaultURIReplaced = false;
            this.textField = (JUndoableTextField)((JTextFieldFormField)uriField).getComponent();
            this.textField.requestFocus();
            this.originalFont = this.textField.getFont();
            this.textField.setFont(this.originalFont.deriveFont(2));
            this.textField.setForeground(new Color(170, 170, 170));
            this.addListenersToTextField();
        }
        return this.dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetUriField() {
        if (!this.defaultURIReplaced && this.textField != null) {
            try {
                this.defaultURIReplaced = true;
                this.textField.setText("");
                this.textField.setFont(this.originalFont);
                this.textField.setForeground(Color.BLACK);
            }
            finally {
                if (this.initialKeyListener != null) {
                    this.textField.removeKeyListener(this.initialKeyListener);
                }
                if (this.initialMouseListener != null) {
                    this.textField.removeMouseListener(this.initialMouseListener);
                }
            }
        }
    }

    private void addListenersToTextField() {
        this.initialKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                RestUriDialogHandler.this.resetUriField();
            }
        };
        this.textField.addKeyListener(this.initialKeyListener);
        this.initialMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RestUriDialogHandler.this.resetUriField();
            }
        };
        this.textField.addMouseListener(this.initialMouseListener);
    }

    public String getUri() {
        if (this.dialog.getReturnValue() != 1) {
            return null;
        }
        String uri = this.dialog.getValue(this.uriLabelKey).trim();
        return uri.equals(this.exampleUri) ? "" : uri;
    }
}

