/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RESTMockActionConfig;
import com.eviware.soapui.config.RESTMockResponseConfig;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.mock.RestMockRequest;
import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.rest.mock.RestMockResult;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.support.AbstractMockOperation;
import com.eviware.soapui.impl.support.HasHelpUrl;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.UISupport;
import com.google.common.io.CharStreams;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class RestMockAction
extends AbstractMockOperation<RESTMockActionConfig, RestMockResponse>
implements HasHelpUrl {
    private RestResource resource = null;

    public RestMockAction(RestMockService mockService, RESTMockActionConfig config) {
        super(config, mockService, RestMockAction.getIconName(config));
        mockService.getMockOperationByName(config.getName());
        List<RESTMockResponseConfig> responseConfigs = config.getResponseList();
        for (RESTMockResponseConfig responseConfig : responseConfigs) {
            RestMockResponse restMockResponse = new RestMockResponse(this, responseConfig);
            restMockResponse.addPropertyChangeListener(this);
            this.addMockResponse(restMockResponse);
        }
        super.setupConfig(config);
    }

    public RestMockAction(RestMockService mockService, RESTMockActionConfig config, RestRequest request) {
        this(mockService, config);
        this.resource = request.getResource();
    }

    public static String getIconName(RESTMockActionConfig methodConfig) {
        if (methodConfig.isSetMethod()) {
            return RestMockAction.getIconName(methodConfig.getMethod());
        }
        return RestMockAction.getDefaultIcon();
    }

    private static String getIconName(String method) {
        return "/mock_" + method.toLowerCase() + "_method.gif";
    }

    public static String getDefaultIcon() {
        return RestMockAction.getIconName(RestRequestInterface.HttpMethod.GET.name());
    }

    @Override
    public RestMockService getMockService() {
        return (RestMockService)this.getParent();
    }

    @Override
    public void removeResponseFromConfig(int index) {
        ((RESTMockActionConfig)this.getConfig()).removeResponse(index);
    }

    @Override
    public Operation getOperation() {
        return this.resource;
    }

    @Override
    public String getScriptHelpUrl() {
        return "/rest-testing-mocking/reference/mock-response-editor.html";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getMockResponses();
    }

    @Override
    public RestMockResponse addNewMockResponse(String name) {
        RESTMockResponseConfig restMockResponseConfig = ((RESTMockActionConfig)this.getConfig()).addNewResponse();
        restMockResponseConfig.setName(name);
        RestMockResponse mockResponse = new RestMockResponse(this, restMockResponseConfig);
        this.addMockResponse(mockResponse);
        if (this.getMockResponseCount() == 1 && restMockResponseConfig.getResponseContent() != null) {
            this.setDefaultResponse(restMockResponseConfig.getResponseContent().toString());
        }
        this.getMockService().fireMockResponseAdded(mockResponse);
        this.notifyPropertyChanged("mockResponses", null, mockResponse);
        return mockResponse;
    }

    public RestMockResult dispatchRequest(RestMockRequest request) throws DispatchException {
        if (this.getMockResponseCount() == 0) {
            throw new DispatchException("Missing MockResponse(s) in MockOperation [" + this.getName() + "]");
        }
        try {
            RestMockResult result = new RestMockResult(request);
            MockResponse mockResponse = this.getDispatcher().selectMockResponse(request, result);
            result.setMockResponse(mockResponse);
            result.setMockOperation(this);
            if (mockResponse == null) {
                mockResponse = this.getMockResponseByName(this.getDefaultResponse());
            }
            if (mockResponse == null) {
                throw new DispatchException("Failed to find MockResponse");
            }
            result.setMockResponse(mockResponse);
            mockResponse.execute(request, result);
            return result;
        }
        catch (Exception e) {
            throw new DispatchException(e);
        }
    }

    public String getResourcePath() {
        return ((RESTMockActionConfig)this.getConfig()).getResourcePath();
    }

    public void setMethod(RestRequestInterface.HttpMethod method) {
        ((RESTMockActionConfig)this.getConfig()).setMethod(method.name());
        this.setIcon(UISupport.createImageIcon(RestMockAction.getIconName(method.name())));
        this.notifyPropertyChanged("httpMethod", null, this);
    }

    public RestRequestInterface.HttpMethod getMethod() {
        return RestRequestInterface.HttpMethod.valueOf(((RESTMockActionConfig)this.getConfig()).getMethod());
    }

    public void setResourcePath(String path) {
        ((RESTMockActionConfig)this.getConfig()).setResourcePath(path);
        this.notifyPropertyChanged("resourcePath", null, this);
    }

    public void setResource(RestResource resource) {
        this.resource = resource;
    }

    @Override
    public void setExampleScript() {
        if (this.getScript() == null) {
            try {
                String groovyScriptName = "com/eviware/soapui/impl/rest/mock/dispatching-script-sample.groovy";
                InputStream groovyStream = this.getClass().getClassLoader().getResourceAsStream(groovyScriptName);
                InputStreamReader groovyReader = new InputStreamReader(groovyStream);
                String groovyScript = CharStreams.toString((Readable)groovyReader);
                this.setScript(groovyScript);
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
    }

    @Override
    public String getHelpUrl() {
        return "/REST-Service-Mocking/mock-action-editor.html";
    }
}

