/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.json;

import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.json.JSON;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class JsonResponseMessageExchangeView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final MessageExchangeModelItem messageExchangeModelItem;
    private JPanel contentPanel;
    private RSyntaxTextArea contentEditor;
    private boolean updatingRequest;
    private JPanel panel;

    public JsonResponseMessageExchangeView(XmlEditor editor, MessageExchangeModelItem messageExchangeModelItem) {
        super("JSON", editor, "JSON Response");
        this.messageExchangeModelItem = messageExchangeModelItem;
        messageExchangeModelItem.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(this.buildToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        this.messageExchangeModelItem.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        return new JPanel();
    }

    private Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = SyntaxEditorUtil.createDefaultJsonSyntaxTextArea();
        MessageExchange me = this.messageExchangeModelItem.getMessageExchange();
        if (me != null) {
            this.setEditorContent(me);
        }
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.contentEditor);
        scrollPane.setLineNumbersEnabled(true);
        scrollPane.setFoldIndicatorEnabled(true);
        this.contentPanel.add((Component)scrollPane);
        this.contentEditor.setEditable(false);
        return this.contentPanel;
    }

    protected void setEditorContent(MessageExchange me) {
        if (me == null) {
            this.contentEditor.setText("");
        } else {
            String content = "<Not JSON content>";
            if (JsonUtil.seemsToBeJsonContentType(me.getResponseHeaders().get("Content-Type", ""))) {
                try {
                    JSON json = new JsonUtil().parseTrimmedText(me.getResponseContent());
                    content = json.isEmpty() ? "<Empty JSON content>" : json.toString(3);
                }
                catch (Throwable e) {
                    if (!"Invalid JSON String".equals(e.getMessage())) {
                        e.printStackTrace();
                    }
                    content = me.getResponseContent();
                }
                this.contentEditor.setText(content);
            } else {
                this.contentEditor.setText("<Not JSON content>");
            }
        }
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("messageExchange") && !this.updatingRequest) {
            this.setEditorContent((MessageExchange)evt.getNewValue());
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

