/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.json;

import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class JsonResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final HttpRequestInterface<?> httpRequest;
    private RSyntaxTextArea contentEditor;
    private boolean updatingRequest;
    private JPanel panel;

    public JsonResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("JSON", httpRequestMessageEditor, "JSON Response");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)UISupport.createToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        this.httpRequest.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        return new JPanel();
    }

    private Component buildContent() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = SyntaxEditorUtil.createDefaultJavaScriptSyntaxTextArea();
        HttpResponse response = this.httpRequest.getResponse();
        if (response != null) {
            this.setEditorContent(response);
        }
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.contentEditor);
        scrollPane.setFoldIndicatorEnabled(true);
        scrollPane.setLineNumbersEnabled(true);
        contentPanel.add((Component)scrollPane);
        this.contentEditor.setEditable(false);
        return contentPanel;
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse == null || httpResponse.getContentAsString() == null) {
            this.contentEditor.setText("");
        } else if (JsonUtil.seemsToBeJsonContentType(httpResponse.getContentType())) {
            String content;
            try {
                JSON json = new JsonUtil().parseTrimmedText(httpResponse.getContentAsString());
                content = json.isEmpty() ? "<Empty JSON content>" : json.toString(3);
            }
            catch (JSONException e) {
                content = httpResponse.getContentAsString();
            }
            this.contentEditor.setText(content);
        } else {
            this.contentEditor.setText("The content you are trying to view cannot be viewed as JSON");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && !this.updatingRequest) {
            this.updatingRequest = true;
            this.setEditorContent((HttpResponse)evt.getNewValue());
            this.updatingRequest = false;
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

