/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.panels.component.RestResourceEditor;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang.mutable.MutableBoolean;

public class RestResourceDesktopPanel
extends ModelItemDesktopPanel<RestResource> {
    public static final String REST_RESOURCE_EDITOR = "rest-resource-editor";
    JTextField pathTextField;
    private MutableBoolean updating = new MutableBoolean();
    private RestParamsTable paramsTable;

    public RestResourceDesktopPanel(RestResource modelItem) {
        super(modelItem);
        this.setName(REST_RESOURCE_EDITOR);
        this.add(this.buildToolbar(), "North");
        this.add(this.buildContent(), "Center");
    }

    private Component buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        this.paramsTable = new RestParamsTable(((RestResource)this.getModelItem()).getParams(), true, NewRestResourceActionBase.ParamLocation.RESOURCE, true, false);
        tabs.addTab("Resource Parameters", this.paramsTable);
        return UISupport.createTabPanel(tabs, false);
    }

    @Override
    public String getTitle() {
        return this.getName((RestResource)this.getModelItem());
    }

    public RestParamsTable getParamsTable() {
        return this.paramsTable;
    }

    @Override
    protected boolean release() {
        this.paramsTable.release();
        return super.release();
    }

    private String getName(RestResource modelItem) {
        if (modelItem.getParentResource() != null) {
            return this.getName(modelItem.getParentResource()) + "/" + modelItem.getName();
        }
        return modelItem.getName();
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(RestResourceDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("NewRestMethodAction", this.getModelItem(), null, "/create_empty_method.gif"), true));
        toolbar.addSeparator();
        this.pathTextField = new RestResourceEditor((RestResource)this.getModelItem(), this.updating);
        toolbar.addFixed(new JLabel("Resource Path"));
        toolbar.addSeparator(new Dimension(3, 3));
        toolbar.addWithOnlyMinimumHeight(this.pathTextField);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/REST-Testing/rest-resources-and-methods.html")));
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ((RestResource)this.getModelItem()).dependsOn(modelItem);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return this.release();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("path") && !this.updating.booleanValue()) {
            this.updating.setValue(true);
            this.pathTextField.setText(((RestResource)this.getModelItem()).getFullPath());
            this.updating.setValue(false);
        }
        this.paramsTable.refresh();
        super.propertyChange(evt);
    }
}

