/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.File;
import java.io.IOException;

public class SaveProjectAsAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "SaveProjectAsAction";

    public SaveProjectAsAction() {
        super("Save Project As", "Saves this project to a new file");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        try {
            String path = project.getPath();
            if (path == null) {
                project.save();
            } else {
                File file = UISupport.getFileDialogs().saveAs(this, "Select soapui project file", "xml", "XML", new File(path));
                if (file == null) {
                    return;
                }
                String fileName = file.getAbsolutePath();
                if (fileName == null) {
                    return;
                }
                if (project.saveAs(fileName) == SaveStatus.SUCCESS) {
                    project.getWorkspace().save(true);
                }
            }
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Failed to save project; " + e1);
        }
    }
}

