/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockResponseXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateEmptyWsdlMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateFaultWsdlMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.RecreateMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.WSIValidateResponseAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.ui.support.AbstractMockResponseDesktopPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class AbstractWsdlMockResponseDesktopPanel<ModelItemType extends ModelItem>
extends AbstractMockResponseDesktopPanel<ModelItemType, WsdlMockResponse> {
    private JButton createEmptyButton;
    private JButton createFaultButton;
    private AbstractAction wsiValidateAction;
    private InternalPropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private JButton openRequestButton;
    private JButton recreateButton;

    public AbstractWsdlMockResponseDesktopPanel(ModelItemType modelItem) {
        super(modelItem);
        modelItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected JComponent buildContent() {
        Object mockResponse = this.getMockResponse();
        this.createEmptyButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new CreateEmptyWsdlMockResponseAction((MockResponse)mockResponse), this.isBidirectional());
        this.createFaultButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new CreateFaultWsdlMockResponseAction((MockResponse)mockResponse), this.isBidirectional());
        this.wsiValidateAction = SwingActionDelegate.createDelegate(new WSIValidateResponseAction(), mockResponse, "alt W");
        this.openRequestButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("OpenRequestForMockResponseAction", mockResponse, null, "/open_request.gif"), true);
        this.recreateButton = AbstractWsdlMockResponseDesktopPanel.createActionButton(new RecreateMockResponseAction((MockResponse)mockResponse), this.isBidirectional());
        return super.buildContent();
    }

    @Override
    protected void createToolbar(JXToolBar toolbar) {
        toolbar.add(this.openRequestButton);
        toolbar.addUnrelatedGap();
        toolbar.add(this.recreateButton);
        toolbar.add(this.createEmptyButton);
        toolbar.add(this.createFaultButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.recreateButton.setEnabled(enabled);
        this.createEmptyButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    protected boolean isBidirectional() {
        return ((WsdlMockResponse)this.getMockResponse()).getMockOperation().getOperation().isBidirectional();
    }

    @Override
    public String getHelpUrl() {
        return "/soap-and-wsdl/working-with-messages.html";
    }

    @Override
    public boolean onClose(boolean canCancel) {
        ((WsdlMockResponse)this.getMockResponse()).removePropertyChangeListener(this.propertyChangeListener);
        return super.onClose(canCancel);
    }

    @Override
    protected AbstractMockResponseDesktopPanel.MockResponseMessageEditor buildResponseEditor() {
        return new WsdlMockResponseMessageEditor((XmlDocument)new MockResponseXmlDocument((MockResponse)this.getMockResponse()));
    }

    public class WsdlMockResponseMessageEditor
    extends AbstractMockResponseDesktopPanel.MockResponseMessageEditor {
        public WsdlMockResponseMessageEditor(XmlDocument document) {
            super(AbstractWsdlMockResponseDesktopPanel.this, document);
            if (AbstractWsdlMockResponseDesktopPanel.this.isBidirectional()) {
                XmlSourceEditorView editor = this.getSourceEditor();
                JPopupMenu inputPopup = editor.getEditorPopup();
                inputPopup.insert(AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction, 3);
            }
        }
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction.setEnabled(AbstractWsdlMockResponseDesktopPanel.this.isBidirectional());
            }
        }
    }
}

