/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.config.JdbcRequestTestStepConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.support.panels.AbstractHttpRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcSubmit;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.DefaultPropertyHolderTableModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import com.eviware.soapui.support.jdbc.JdbcUtils;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class JdbcRequestTestStepDesktopPanel
extends ModelItemDesktopPanel<JdbcRequestTestStep>
implements SubmitListener {
    private static final Logger log = Logger.getLogger(AbstractHttpRequestDesktopPanel.class);
    private static final MessageSupport messages = MessageSupport.getMessages(JdbcRequestTestStepDesktopPanel.class);
    protected JPanel configPanel;
    private JButton addAssertionButton;
    protected JInspectorPanel inspectorPanel;
    protected JdbcRequestTestStep jdbcRequestTestStep;
    protected JComponentInspector<?> assertionInspector;
    protected AssertionsPanel assertionsPanel;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    protected JComponent requestEditor;
    protected ModelItemXmlEditor<?, ?> responseEditor;
    protected JPanel panel;
    protected SimpleForm configForm;
    protected static final String DRIVER_FIELD = "Driver";
    protected static final String CONNSTR_FIELD = "Connection String";
    protected static final String PASS_FIELD = "Password";
    public static final String QUERY_FIELD = "SQL Query";
    protected static final String STOREDPROCEDURE_FIELD = "Stored Procedure";
    protected static final String RESULT_COLUMNS_NAMES_TO_UPPER_CASE = messages.get("JdbcRequestTestStepDesktopPanel.ResultColumnsToUpperCase.Name");
    protected static final String DATA_CONNECTION_FIELD = "Connection";
    protected static final String QUERY_ELEMENT = "query";
    protected static final String STOREDPROCEDURE_ELEMENT = "stored-procedure";
    protected Connection connection;
    protected RSyntaxTextArea queryArea;
    protected JCheckBox isStoredProcedureCheckBox;
    protected JCheckBox resultColumnsNamesToUpperCaseCheckBox;
    protected JTextField driverTextField;
    protected JTextField connStrTextField;
    protected JButton testConnectionButton;
    protected JPasswordField passField;
    private Submit submit;
    private SubmitAction submitAction;
    protected JButton submitButton;
    private JToggleButton tabsButton;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private boolean responseHasFocus;
    private JSplitPane requestSplitPane;
    private JEditorStatusBarWithProgress statusBar;
    private JButton cancelButton;
    private JButton splitButton;
    protected JComponent propertiesTableComponent;
    private JComponentInspector<?> logInspector;
    protected JLogList logArea;
    private long startTime;
    protected JButton reconfigureConnPropertiesButton;
    protected PropertyHolderTable propertyHolderTable;
    protected JdbcRequestTestStepConfig jdbcRequestTestStepConfig;

    public JdbcRequestTestStepDesktopPanel(JdbcRequestTestStep modelItem) {
        super(modelItem);
        this.jdbcRequestTestStep = modelItem;
        this.initConfig();
        this.initContent();
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(this.jdbcRequestTestStep.getTestCase()));
        this.jdbcRequestTestStep.addAssertionsListener(this.assertionsListener);
    }

    protected void initConfig() {
        this.jdbcRequestTestStepConfig = this.jdbcRequestTestStep.getJdbcRequestTestStepConfig();
    }

    protected JComponent buildContent() {
        JComponent content;
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.submitAction = new SubmitAction();
        this.submitButton = JdbcRequestTestStepDesktopPanel.createActionButton(this.submitAction, true);
        this.submitButton.setEnabled(this.enableSubmit());
        this.cancelButton = JdbcRequestTestStepDesktopPanel.createActionButton(new CancelAction(), false);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.splitButton = JdbcRequestTestStepDesktopPanel.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.addAssertionButton = UISupport.createToolbarButton(new AddAssertionAction(this.jdbcRequestTestStep));
        this.addAssertionButton.setEnabled(true);
        this.requestTabs = new JTabbedPane();
        this.requestTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int ix = JdbcRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex();
                        if (ix == 0) {
                            JdbcRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                        } else if (ix == 1 && JdbcRequestTestStepDesktopPanel.this.responseEditor != null) {
                            JdbcRequestTestStepDesktopPanel.this.responseEditor.requestFocus();
                        }
                    }
                });
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JdbcRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || JdbcRequestTestStepDesktopPanel.this.responseHasFocus) {
                    JdbcRequestTestStepDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    JdbcRequestTestStepDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        this.requestEditor = this.buildRequestConfigPanel();
        this.responseEditor = this.buildResponseEditor();
        if (this.jdbcRequestTestStep.getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Request", this.requestEditor);
            if (this.responseEditor != null) {
                this.requestTabs.addTab("Response", this.responseEditor);
            }
            this.tabsButton.setSelected(true);
            this.splitButton.setEnabled(false);
            content = this.requestTabPanel;
        } else {
            this.requestSplitPane.setTopComponent(this.requestEditor);
            this.requestSplitPane.setBottomComponent(this.responseEditor);
            this.requestSplitPane.setDividerLocation(0.5);
            content = this.requestSplitPane;
        }
        this.inspectorPanel = JInspectorPanelFactory.build(content);
        this.inspectorPanel.setDefaultDividerLocation(0.7f);
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((JdbcRequestTestStep)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        return this.inspectorPanel.getComponent();
    }

    protected JComponent buildRequestConfigPanel() {
        this.configPanel = UISupport.addTitledBorder(new JPanel(new BorderLayout()), "Configuration");
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.configForm = new SimpleForm();
            this.createSimpleJdbcConfigForm();
            this.addStoreProcedureChangeListener();
            this.addResultColumnsNamesToUpperCaseChangeListener();
            this.panel.add(new JScrollPane(this.configForm.getPanel()));
        }
        this.configPanel.add((Component)this.panel, "Center");
        this.propertiesTableComponent = this.buildProperties();
        JSplitPane split = UISupport.createVerticalSplit(this.propertiesTableComponent, this.configPanel);
        split.setDividerLocation(120);
        split.setPreferredSize(new Dimension(330, 500));
        return new JScrollPane(split);
    }

    protected void initContent() {
        this.jdbcRequestTestStep.getJdbcRequest().addSubmitListener(this);
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JdbcRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || JdbcRequestTestStepDesktopPanel.this.responseHasFocus) {
                    JdbcRequestTestStepDesktopPanel.this.responseEditor.requestFocusInWindow();
                } else {
                    JdbcRequestTestStepDesktopPanel.this.requestEditor.requestFocusInWindow();
                }
            }
        });
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    protected JComponent buildProperties() {
        this.propertyHolderTable = new PropertyHolderTable((TestPropertyHolder)this.getModelItem()){

            @Override
            protected DefaultPropertyHolderTableModel getPropertyHolderTableModel() {
                return new DefaultPropertyHolderTableModel(this.holder){

                    @Override
                    public String[] getPropertyNames() {
                        ArrayList<String> propertyNamesList = new ArrayList<String>();
                        for (String name : holder.getPropertyNames()) {
                            if (name.equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
                            propertyNamesList.add(name);
                        }
                        return propertyNamesList.toArray(new String[propertyNamesList.size()]);
                    }
                };
            }
        };
        JUndoableTextField textField = new JUndoableTextField(true);
        PropertyExpansionPopupListener.enable(textField, this.getModelItem());
        this.propertyHolderTable.getPropertiesTable().setDefaultEditor(String.class, new DefaultCellEditor(textField));
        return this.propertyHolderTable;
    }

    public PropertyHolderTable getPropertyHolderTable() {
        return this.propertyHolderTable;
    }

    public void setPropertyHolderTable(StringToStringMap preparedProperties) {
        String[] names = this.propertyHolderTable.getHolder().getPropertyNames();
        if (names.length > 0) {
            for (String propertyName : names) {
                ((MutableTestPropertyHolder)this.propertyHolderTable.getHolder()).removeProperty(propertyName);
            }
        }
        this.propertyHolderTable.getPropertiesTable().removeAll();
        if (preparedProperties != null) {
            int i = 0;
            for (String key : preparedProperties.keySet()) {
                String value = (String)preparedProperties.get(key);
                ((MutableTestPropertyHolder)this.propertyHolderTable.getHolder()).addProperty(key);
                ((MutableTestPropertyHolder)this.propertyHolderTable.getHolder()).setPropertyValue(key, value);
                ++i;
            }
        }
    }

    protected JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        toolbar.addFixed(this.submitButton);
        toolbar.add(this.cancelButton);
        toolbar.addFixed(this.addAssertionButton);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("/JDBC/getting-started.html")));
        return toolbar;
    }

    public JdbcRequestTestStep getJdbcRequestTestStep() {
        return this.jdbcRequestTestStep;
    }

    public void setQuery(String query) {
        if (this.configForm != null) {
            this.configForm.setComponentValue(QUERY_FIELD, query);
            this.jdbcRequestTestStep.setQuery(query);
        } else {
            this.jdbcRequestTestStep.setQuery(query);
        }
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            @Override
            public void dataChanged(ListModel model) {
                JdbcRequestTestStepDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new JdbcAssertionsPanel(this.jdbcRequestTestStep){};
    }

    protected void createSimpleJdbcConfigForm() {
        this.configForm.addSpace(5);
        this.configForm.setDefaultTextFieldColumns(50);
        this.driverTextField = this.configForm.appendTextField(DRIVER_FIELD, "JDBC Driver to use");
        this.driverTextField.setText(this.jdbcRequestTestStep.getDriver());
        PropertyExpansionPopupListener.enable(this.driverTextField, (ModelItem)this.jdbcRequestTestStep);
        this.addDriverDocumentListener();
        this.connStrTextField = this.configForm.appendTextField(CONNSTR_FIELD, "JDBC Driver Connection String");
        this.connStrTextField.setText(this.jdbcRequestTestStep.getConnectionString());
        PropertyExpansionPopupListener.enable(this.connStrTextField, (ModelItem)this.jdbcRequestTestStep);
        this.addConnStrDocumentListener();
        this.passField = this.configForm.appendPasswordField(PASS_FIELD, "Connection string Password");
        this.passField.setVisible(false);
        this.passField.setText(this.jdbcRequestTestStep.getPassword());
        this.addPasswordDocumentListener();
        this.reconfigureConnPropertiesButton = new JButton();
        this.configForm.addLeftComponent(this.reconfigureConnPropertiesButton);
        this.reconfigureConnPropertiesButton.setVisible(false);
        this.configForm.appendSeparator();
        this.testConnectionButton = this.configForm.appendButton("TestConnection", "Test selected database connection");
        this.testConnectionButton.setAction(new TestConnectionAction());
        this.testConnectionButton.setEnabled(this.enableTestConnection());
        this.submitButton.setEnabled(this.enableSubmit());
        this.queryArea = SyntaxEditorUtil.createDefaultSQLSyntaxTextArea();
        PropertyExpansionPopupListener.enable(this.queryArea, (ModelItem)this.jdbcRequestTestStep);
        this.queryArea.setText(this.jdbcRequestTestStep.getQuery());
        JScrollPane scrollPane = new JScrollPane((Component)this.queryArea);
        scrollPane.setPreferredSize(new Dimension(400, 150));
        this.configForm.append(QUERY_FIELD, scrollPane);
        this.queryArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setQuery(JdbcRequestTestStepDesktopPanel.this.queryArea.getText());
                JdbcRequestTestStepDesktopPanel.this.submitButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableSubmit());
            }
        });
        this.isStoredProcedureCheckBox = this.configForm.appendCheckBox(STOREDPROCEDURE_FIELD, "Select if this is a stored procedure", this.jdbcRequestTestStep.isStoredProcedure());
        this.resultColumnsNamesToUpperCaseCheckBox = this.configForm.appendCheckBox(RESULT_COLUMNS_NAMES_TO_UPPER_CASE, messages.get("JdbcRequestTestStepDesktopPanel.ResultColumnsToUpperCase.Description"), this.jdbcRequestTestStep.isConvertColumnNamesToUpperCase());
    }

    protected void addPasswordDocumentListener() {
        this.passField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setPassword(JdbcRequestTestStepDesktopPanel.this.configForm.getComponentValue(JdbcRequestTestStepDesktopPanel.PASS_FIELD));
                JdbcRequestTestStepDesktopPanel.this.testConnectionButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableTestConnection());
                JdbcRequestTestStepDesktopPanel.this.submitButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableSubmit());
            }
        });
    }

    protected void addConnStrDocumentListener() {
        this.connStrTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setConnectionString(JdbcRequestTestStepDesktopPanel.this.configForm.getComponentValue(JdbcRequestTestStepDesktopPanel.CONNSTR_FIELD));
                JdbcRequestTestStepDesktopPanel.this.testConnectionButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableTestConnection());
                JdbcRequestTestStepDesktopPanel.this.submitButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableSubmit());
            }
        });
    }

    protected void addDriverDocumentListener() {
        this.driverTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setDriver(JdbcRequestTestStepDesktopPanel.this.configForm.getComponentValue(JdbcRequestTestStepDesktopPanel.DRIVER_FIELD));
                JdbcRequestTestStepDesktopPanel.this.testConnectionButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableTestConnection());
                JdbcRequestTestStepDesktopPanel.this.submitButton.setEnabled(JdbcRequestTestStepDesktopPanel.this.enableSubmit());
            }
        });
    }

    protected void addStoreProcedureChangeListener() {
        this.isStoredProcedureCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setStoredProcedure(((JCheckBox)arg0.getSource()).isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (UISupport.confirm("Would you like to empty current sql and properties?", "Reset query and properties")) {
                            JdbcRequestTestStepDesktopPanel.this.queryArea.setText("");
                            ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getPropertyHolderTable().getHolder()).removeAllProperties();
                        }
                    }
                });
            }
        });
    }

    protected void addResultColumnsNamesToUpperCaseChangeListener() {
        this.resultColumnsNamesToUpperCaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.setConvertColumnNamesToUpperCase(((JCheckBox)arg0.getSource()).isSelected());
            }
        });
    }

    protected boolean enableTestConnection() {
        if (StringUtils.isNullOrEmpty(this.jdbcRequestTestStep.getDriver()) || StringUtils.isNullOrEmpty(this.jdbcRequestTestStep.getConnectionString()) || JdbcRequestTestStep.isNeededPassword(this.jdbcRequestTestStep.getConnectionString()) && StringUtils.isNullOrEmpty(this.jdbcRequestTestStep.getPassword())) {
            return false;
        }
        if (this.jdbcRequestTestStep.getConnectionString().contains("PASS_VALUE")) {
            return !StringUtils.isNullOrEmpty(this.jdbcRequestTestStep.getPassword());
        }
        return true;
    }

    protected boolean enableSubmit() {
        return this.enableTestConnection() && !StringUtils.isNullOrEmpty(this.jdbcRequestTestStep.getQuery());
    }

    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new JdbcResponseMessageEditor();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((JdbcRequestTestStep)this.getModelItem()).getTestCase() || modelItem == ((JdbcRequestTestStep)this.getModelItem()).getTestCase().getTestSuite() || modelItem == ((JdbcRequestTestStep)this.getModelItem()).getTestCase().getTestSuite().getProject();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.configPanel.removeAll();
        SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
        this.jdbcRequestTestStep.removeAssertionsListener(this.assertionsListener);
        this.jdbcRequestTestStep.getJdbcRequest().removeSubmitListener(this);
        this.responseEditor.release();
        this.assertionsPanel.release();
        this.inspectorPanel.release();
        this.propertyHolderTable.release();
        return this.release();
    }

    protected void onSubmit() {
        if (this.submit != null && this.submit.getStatus() == Submit.Status.RUNNING) {
            if (UISupport.confirm("Cancel current request?", "Submit Request")) {
                this.submit.cancel();
            } else {
                return;
            }
        }
        try {
            this.submit = this.doSubmit();
        }
        catch (Request.SubmitException e1) {
            SoapUI.logError(e1);
        }
    }

    protected Submit doSubmit() throws Request.SubmitException {
        Analytics.trackAction((String)SoapUIActions.RUN_TEST_STEP.getActionName(), (String[])new String[]{"StepType", "JDBC"});
        return this.jdbcRequestTestStep.getJdbcRequest().submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    protected void onCancel() {
        if (this.submit == null) {
            return;
        }
        this.cancelButton.setEnabled(false);
        this.submit.cancel();
        this.setEnabled(true);
        this.submit = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.responseEditor != null) {
            this.responseEditor.setEditable(enabled);
        }
        this.submitButton.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.driverTextField.setEnabled(enabled);
        this.connStrTextField.setEnabled(enabled);
        this.passField.setEnabled(enabled);
        this.queryArea.setEnabled(enabled);
        this.queryArea.setEditable(enabled);
        this.isStoredProcedureCheckBox.setEnabled(enabled);
        this.propertiesTableComponent.setEnabled(enabled);
        this.testConnectionButton.setEnabled(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        if (submit.getRequest() != this.jdbcRequestTestStep.getJdbcRequest()) {
            return;
        }
        Submit.Status status = submit.getStatus();
        JdbcResponse response = (JdbcResponse)submit.getResponse();
        if (status == Submit.Status.FINISHED) {
            this.jdbcRequestTestStep.setResponse(response, context);
        }
        this.cancelButton.setEnabled(false);
        this.setEnabled(true);
        String message = null;
        String infoMessage = null;
        String requestName = this.jdbcRequestTestStep.getName();
        String rawSql = "";
        if (status == Submit.Status.CANCELED) {
            message = "CANCELED";
            infoMessage = "[" + requestName + "] - CANCELED";
        } else if (status == Submit.Status.ERROR || response == null) {
            message = "Error getting response; " + submit.getError();
            infoMessage = "Error getting response for [" + requestName + "]; " + submit.getError();
        } else {
            message = "response time: " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            infoMessage = "Got response for [" + requestName + "] in " + response.getTimeTaken() + "ms (" + response.getContentLength() + " bytes)";
            rawSql = ((JdbcSubmit)submit).getRawSql();
            if (!this.splitButton.isEnabled()) {
                this.requestTabs.setSelectedIndex(1);
            }
            this.responseEditor.requestFocus();
        }
        if (!StringUtils.isNullOrEmpty(rawSql)) {
            this.logMessages("Sql executed: " + rawSql, rawSql);
        }
        this.logMessages(message, infoMessage);
        if (((JdbcRequestTestStep)this.getModelItem()).getSettings().getBoolean(UISettings.AUTO_VALIDATE_RESPONSE)) {
            this.responseEditor.getSourceEditor().validate();
        }
        this.submit = null;
        this.updateStatusIcon();
    }

    protected void logMessages(String message, String infoMessage) {
        log.info((Object)infoMessage);
        this.statusBar.setInfo(message);
        this.logArea.addLine(DateUtil.formatFull(new Date(this.startTime)) + " - " + message);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        if (submit.getRequest() != this.jdbcRequestTestStep.getJdbcRequest()) {
            return true;
        }
        this.setEnabled(false);
        this.cancelButton.setEnabled(this.submit != null);
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals(JdbcRequestTestStep.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        }
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = this.jdbcRequestTestStep.getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.png"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        @Override
        public void assertionAdded(TestAssertion assertion) {
            JdbcRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionRemoved(TestAssertion assertion) {
            JdbcRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            JdbcRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.png"));
            this.putValue("ShortDescription", "Aborts ongoing request");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcRequestTestStepDesktopPanel.this.onCancel();
        }
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JdbcRequestTestStepDesktopPanel.this.splitButton.isEnabled()) {
                JdbcRequestTestStepDesktopPanel.this.splitButton.setEnabled(false);
                JdbcRequestTestStepDesktopPanel.this.removeContent(JdbcRequestTestStepDesktopPanel.this.requestSplitPane);
                JdbcRequestTestStepDesktopPanel.this.setContent(JdbcRequestTestStepDesktopPanel.this.requestTabPanel);
                JdbcRequestTestStepDesktopPanel.this.requestTabs.addTab("Request", JdbcRequestTestStepDesktopPanel.this.requestEditor);
                if (JdbcRequestTestStepDesktopPanel.this.responseEditor != null) {
                    JdbcRequestTestStepDesktopPanel.this.requestTabs.addTab("Response", JdbcRequestTestStepDesktopPanel.this.responseEditor);
                }
                if (JdbcRequestTestStepDesktopPanel.this.responseHasFocus) {
                    JdbcRequestTestStepDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    JdbcRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                }
                JdbcRequestTestStepDesktopPanel.this.requestTabs.repaint();
            } else {
                int selectedIndex = JdbcRequestTestStepDesktopPanel.this.requestTabs.getSelectedIndex();
                JdbcRequestTestStepDesktopPanel.this.splitButton.setEnabled(true);
                JdbcRequestTestStepDesktopPanel.this.removeContent(JdbcRequestTestStepDesktopPanel.this.requestTabPanel);
                JdbcRequestTestStepDesktopPanel.this.setContent(JdbcRequestTestStepDesktopPanel.this.requestSplitPane);
                JdbcRequestTestStepDesktopPanel.this.requestSplitPane.setTopComponent(JdbcRequestTestStepDesktopPanel.this.requestEditor);
                if (JdbcRequestTestStepDesktopPanel.this.responseEditor != null) {
                    JdbcRequestTestStepDesktopPanel.this.requestSplitPane.setBottomComponent(JdbcRequestTestStepDesktopPanel.this.responseEditor);
                }
                JdbcRequestTestStepDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0 || JdbcRequestTestStepDesktopPanel.this.responseEditor == null) {
                    JdbcRequestTestStepDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    JdbcRequestTestStepDesktopPanel.this.responseEditor.requestFocus();
                }
                JdbcRequestTestStepDesktopPanel.this.requestSplitPane.repaint();
            }
            JdbcRequestTestStepDesktopPanel.this.revalidate();
        }
    }

    public class SubmitAction
    extends AbstractAction {
        public SubmitAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Submit request to specified database");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcRequestTestStepDesktopPanel.this.onSubmit();
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        @Override
        public void loadTestFinished(LoadTestRunner runner) {
            JdbcRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                JdbcRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void securityTestFinished(SecurityTestRunner runner) {
            JdbcRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                JdbcRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void testCaseFinished(TestCaseRunner runner) {
            JdbcRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((JdbcRequestTestStep)JdbcRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                JdbcRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }
    }

    protected class TestConnectionAction
    extends AbstractAction {
        public TestConnectionAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Test the current Connection");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                DefaultPropertyExpansionContext context = new DefaultPropertyExpansionContext((ModelItem)JdbcRequestTestStepDesktopPanel.this.getModelItem());
                JdbcUtils.initConnection(context, JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getDriver(), JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getConnectionString(), JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getPassword());
                UISupport.showInfoMessage("The Connection Successfully Tested");
            }
            catch (SoapUIException e) {
                SoapUI.logError(e);
                UISupport.showErrorMessage(e.toString());
            }
            catch (SQLException e) {
                SoapUI.logError(e);
                UISupport.showErrorMessage("Can't get the Connection for specified properties; " + e.toString());
            }
        }
    }

    public class JdbcResponseDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        public JdbcResponseDocument() {
            JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.addPropertyChangeListener("response", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireContentChanged();
        }

        @Override
        public void setDocumentContent(DocumentContent documentContent) {
            if (JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getJdbcRequest().getResponse() != null) {
                JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getJdbcRequest().getResponse().setContentAsString(documentContent.getContentAsString());
            }
        }

        @Override
        public void release() {
            super.release();
            JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.removePropertyChangeListener("response", this);
        }

        @Override
        @Nonnull
        public DocumentContent getDocumentContent(EditorDocument.Format format) {
            JdbcResponse response = JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep.getJdbcRequest().getResponse();
            return new DocumentContent(response == null ? null : response.getContentType(), response == null ? null : response.getContentAsString());
        }
    }

    public class JdbcResponseMessageEditor
    extends ResponseMessageXmlEditor<JdbcRequestTestStep, JdbcResponseDocument> {
        public JdbcResponseMessageEditor() {
            super(new JdbcResponseDocument(), JdbcRequestTestStepDesktopPanel.this.jdbcRequestTestStep);
        }
    }

    protected class JdbcAssertionsPanel
    extends AssertionsPanel {
        public JdbcAssertionsPanel(Assertable assertable) {
            super(assertable);
        }
    }
}

