/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.impl.wsdl.support.soap.AbstractSoapVersion;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.FaultDocument;

public class SoapVersion12
extends AbstractSoapVersion {
    private static final QName envelopeQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Envelope");
    private static final QName bodyQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
    private static final QName faultQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final QName headerQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Header");
    public static final SoapVersion12 instance = new SoapVersion12();
    private SchemaTypeLoader soapSchema;
    private XmlObject soapSchemaXml;
    private XmlObject soapEncodingXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoapVersion12() {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            this.soapSchemaXml = XmlUtils.createXmlObject(SoapUI.class.getResource("/com/eviware/soapui/resources/xsds/soapEnvelope12.xsd"));
            this.soapSchema = XmlBeans.loadXsd((XmlObject[])new XmlObject[]{this.soapSchemaXml});
            this.soapEncodingXml = XmlUtils.createXmlObject(SoapUI.class.getResource("/com/eviware/soapui/resources/xsds/soapEncoding12.xsd"));
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            state.restore();
        }
    }

    @Override
    public String getEncodingNamespace() {
        return "http://www.w3.org/2003/05/soap-encoding";
    }

    @Override
    public XmlObject getSoapEncodingSchema() throws XmlException, IOException {
        return this.soapEncodingXml;
    }

    @Override
    public XmlObject getSoapEnvelopeSchema() throws XmlException, IOException {
        return this.soapSchemaXml;
    }

    @Override
    public String getEnvelopeNamespace() {
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    @Override
    public SchemaType getEnvelopeType() {
        return EnvelopeDocument.type;
    }

    public String toString() {
        return "SOAP 1.2";
    }

    @Override
    public String getContentTypeHttpHeader(String encoding, String soapAction) {
        String result = this.getContentType();
        if (encoding != null && encoding.trim().length() > 0) {
            result = result + ";charset=" + encoding;
        }
        if (StringUtils.hasContent(soapAction)) {
            result = result + ";action=" + StringUtils.quote(soapAction);
        }
        return result;
    }

    @Override
    public String getSoapActionHeader(String soapAction) {
        return null;
    }

    @Override
    public String getContentType() {
        return "application/soap+xml";
    }

    @Override
    public QName getBodyQName() {
        return bodyQName;
    }

    @Override
    public QName getEnvelopeQName() {
        return envelopeQName;
    }

    @Override
    public QName getHeaderQName() {
        return headerQName;
    }

    @Override
    protected SchemaTypeLoader getSoapEnvelopeSchemaLoader() {
        return this.soapSchema;
    }

    public static QName getFaultQName() {
        return faultQName;
    }

    @Override
    public SchemaType getFaultType() {
        return FaultDocument.type;
    }

    @Override
    public String getName() {
        return "SOAP 1.2";
    }

    @Override
    public String getFaultDetailNamespace() {
        return this.getEnvelopeNamespace();
    }
}

