/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.definition.support.AbstractDefinitionLoader;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlDefinitionLoader;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.tools.PropertyExpansionRemover;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.xml.sax.InputSource;

public abstract class WsdlLoader
extends AbstractDefinitionLoader
implements WsdlDefinitionLoader {
    private String url;
    private String firstNewURI;
    private String last;
    private String username;
    private String password;
    protected static final Logger log = Logger.getLogger(WsdlLoader.class);

    public WsdlLoader(String url) {
        this.url = url;
        if (!PathUtils.isFilePath(url) && !PathUtils.isRelativePath(url)) {
            try {
                int ix2;
                int ix1;
                URL u = new URL(url);
                String authority = u.getAuthority();
                if (authority != null && (ix1 = authority.lastIndexOf(64)) > (ix2 = authority.indexOf(58)) && ix2 > 0) {
                    this.username = authority.substring(0, ix2);
                    this.password = authority.substring(ix2 + 1, ix1);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public InputSource getBaseInputSource() {
        try {
            log.debug((Object)("Returning baseInputSource [" + this.url + "]"));
            return new InputSource(this.load(this.url));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public abstract InputStream load(String var1) throws Exception;

    @Override
    public XmlObject loadXmlObject(String url, XmlOptions options) throws Exception {
        try {
            if (options == null) {
                options = new XmlOptions();
            }
            if (this.monitor != null) {
                this.monitor.setProgress(this.progressIndex, "Loading [" + url + "]");
            }
            options.setLoadLineNumbers();
            return XmlUtils.createXmlObject(this.readCleanWsdlFrom(url), options);
        }
        catch (XmlException e) {
            XmlError error = e.getError();
            if (error != null) {
                InvalidDefinitionException ex = new InvalidDefinitionException(e);
                ex.setMessage("Error loading [" + url + "]");
                throw ex;
            }
            throw this.makeInvalidDefinitionException(url, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw this.makeInvalidDefinitionException(url, e);
        }
    }

    private InvalidDefinitionException makeInvalidDefinitionException(String url, Exception e) throws InvalidDefinitionException {
        e.printStackTrace();
        log.error((Object)("Failed to load url [" + url + "]"));
        return new InvalidDefinitionException("Error loading [" + url + "]: " + e);
    }

    private String readCleanWsdlFrom(String url) throws Exception {
        String content = XmlUtils.createXmlObject(this.load(url)).xmlText();
        if (SoapUI.getSettings().getBoolean(WsdlSettings.TRIM_WSDL)) {
            content = content.trim();
        }
        return PropertyExpansionRemover.removeExpansions(content);
    }

    @Override
    public String getBaseURI() {
        return this.url;
    }

    @Override
    public void setNewBaseURI(String newUrl) {
        if (this.firstNewURI == null) {
            this.firstNewURI = newUrl;
        }
        this.url = newUrl;
    }

    @Override
    public String getFirstNewURI() {
        return this.firstNewURI == null ? this.url : this.firstNewURI;
    }

    public InputSource getImportInputSource(String parent, String imp) {
        this.last = this.isAbsoluteUrl(imp) ? imp : Tools.joinRelativeUrl(parent, imp);
        try {
            InputStream input = this.load(this.last);
            return input == null ? null : new InputSource(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected boolean isAbsoluteUrl(String tempImp) {
        return (tempImp = tempImp.toUpperCase()).startsWith("HTTP:") || tempImp.startsWith("HTTPS:") || tempImp.startsWith("FILE:");
    }

    public String getLatestImportURI() {
        String result = this.last == null ? this.url : this.last;
        log.debug((Object)("Returning latest import URI [" + result + "]"));
        return result;
    }

    public boolean hasCredentials() {
        return !StringUtils.isNullOrEmpty(this.getUsername()) && !StringUtils.isNullOrEmpty(this.getPassword());
    }

    public String getPassword() {
        return StringUtils.isNullOrEmpty(this.password) ? System.getProperty("soapui.loader.password", this.password) : this.password;
    }

    public String getUsername() {
        return StringUtils.isNullOrEmpty(this.username) ? System.getProperty("soapui.loader.username", this.username) : this.username;
    }
}

