/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsrm;

import com.eviware.soapui.config.WsrmConfigConfig;
import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmContainer;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmUtils;
import com.eviware.soapui.support.PropertyChangeNotifier;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigInteger;

public class WsrmConfig
implements PropertyChangeNotifier {
    private WsrmConfigConfig wsrmConfig;
    private String sequenceIdentifier;
    private Long lastMessageId;
    private String uuid;
    private PropertyChangeSupport propertyChangeSupport;
    private final WsrmContainer container;

    public WsrmConfig(WsrmConfigConfig wsrmConfig, WsrmContainer container) {
        this.setWsrmConfig(wsrmConfig);
        this.container = container;
        this.setPropertyChangeSupport(new PropertyChangeSupport(this));
        this.lastMessageId = 1L;
        if (!wsrmConfig.isSetVersion()) {
            wsrmConfig.setVersion(WsrmVersionTypeConfig.X_1_2);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setWsrmConfig(WsrmConfigConfig wsrmConfig) {
        this.wsrmConfig = wsrmConfig;
    }

    public WsrmConfigConfig getWsrmConfig() {
        return this.wsrmConfig;
    }

    public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public WsrmContainer getContainer() {
        return this.container;
    }

    public void setAckTo(String newAckTo) {
        String oldValue = this.wsrmConfig.getAckTo();
        this.wsrmConfig.setAckTo(newAckTo);
        this.propertyChangeSupport.firePropertyChange("ackTo", oldValue, newAckTo);
    }

    public String getAckTo() {
        return this.wsrmConfig.getAckTo();
    }

    public String getOfferEndpoint() {
        return this.wsrmConfig.getOfferEndpoint();
    }

    public void setSequenceExpires(BigInteger newTimeout) {
        BigInteger oldValue = this.wsrmConfig.getSequenceExpires();
        this.wsrmConfig.setSequenceExpires(newTimeout);
        this.propertyChangeSupport.firePropertyChange("sequenceExpires", oldValue, newTimeout);
    }

    public void setOfferEndpoint(String endpointUri) {
        String oldValue = this.wsrmConfig.getOfferEndpoint();
        this.wsrmConfig.setOfferEndpoint(endpointUri);
        this.propertyChangeSupport.firePropertyChange("offerEndpoint", oldValue, endpointUri);
    }

    public BigInteger getSequenceExpires() {
        return this.wsrmConfig.getSequenceExpires();
    }

    public void setWsrmEnabled(boolean enable) {
        boolean oldValue = this.isWsrmEnabled();
        this.container.setWsrmEnabled(enable);
        this.propertyChangeSupport.firePropertyChange("wsrmEnabled", oldValue, enable);
    }

    public boolean isWsrmEnabled() {
        return this.container.isWsrmEnabled();
    }

    public void setVersion(String arg0) {
        String oldValue = this.getVersion();
        this.wsrmConfig.setVersion(WsrmVersionTypeConfig.Enum.forString(arg0));
        this.propertyChangeSupport.firePropertyChange("version", oldValue, arg0);
    }

    public String getVersion() {
        return this.wsrmConfig.getVersion().toString();
    }

    public void setSequenceIdentifier(String sequenceIdentifier) {
        this.sequenceIdentifier = sequenceIdentifier;
    }

    public String getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public Long nextMessageId() {
        WsrmConfig wsrmConfig = this;
        Long l = wsrmConfig.lastMessageId;
        Long l2 = wsrmConfig.lastMessageId = Long.valueOf(wsrmConfig.lastMessageId + 1L);
        return this.lastMessageId;
    }

    public Long getLastMessageId() {
        return this.lastMessageId;
    }

    public void setLastMessageId(long msgId) {
        this.lastMessageId = msgId;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersionNameSpace() {
        return WsrmUtils.getWsrmVersionNamespace(this.wsrmConfig.getVersion());
    }
}

