/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.testsuite.AssertedXPath;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.ResponseAssertedMessageExchange;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public class RestRequestStepResult
extends WsdlTestStepResult
implements ResponseAssertedMessageExchange,
AssertedXPathsContainer,
MessageExchangeTestStepResult {
    private String requestContent;
    @CheckForNull
    private HttpResponse response;
    private String domain;
    private String username;
    private String endpoint;
    private String encoding;
    private String password;
    private StringToStringMap properties;
    private boolean addedAction;
    private List<AssertedXPath> assertedXPaths;

    public RestRequestStepResult(HttpTestRequestStepInterface step) {
        super((WsdlTestStep)((Object)step));
    }

    @Override
    public Operation getOperation() {
        if (this.response == null) {
            this.response = null;
        }
        return this.response == null ? null : this.response.getRequest().getOperation();
    }

    @Override
    public ModelItem getModelItem() {
        if (this.response != null) {
            return this.response.getRequest();
        }
        return null;
    }

    @Override
    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        return this.requestContent;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public ActionList getActions() {
        if (!this.addedAction) {
            this.addAction(new ShowMessageExchangeAction(this, "TestStep"), true);
            this.addedAction = true;
        }
        return super.getActions();
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.addProperty("Domain", domain);
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.addProperty("Encoding", encoding);
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.addProperty("Endpoint", endpoint);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("Password", password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.addProperty("Username", username);
    }

    @Override
    public void discard() {
        super.discard();
        this.requestContent = null;
        this.response = null;
        this.properties = null;
        this.assertedXPaths = null;
    }

    @Override
    public void writeTo(PrintWriter writer) {
        super.writeTo(writer);
        if (this.response == null) {
            writer.println("\r\n- missing response / garbage collected -");
            return;
        }
        writer.println("\r\n----------------- Properties ------------------------------");
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key) == null) continue;
                writer.println(key + ": " + (String)this.properties.get(key));
            }
        }
        writer.println("\r\n---------------- Request ---------------------------");
        StringToStringsMap headers = this.response.getRequestHeaders();
        for (Map.Entry headerEntry : headers.entrySet()) {
            if (headerEntry.getValue() == null) continue;
            writer.println((String)headerEntry.getKey() + ": " + headerEntry.getValue());
        }
        byte[] rawRequestData = this.response.getRawRequestData();
        if (rawRequestData != null) {
            writer.println("\r\n" + new String(rawRequestData));
        }
        writer.println("\r\n---------------- Response --------------------------");
        headers = this.response.getResponseHeaders();
        for (String key : headers.keySet()) {
            if (headers.get(key) == null) continue;
            writer.println(key + ": " + headers.get(key));
        }
        String respContent = this.response.getContentAsString();
        if (respContent != null) {
            writer.println("\r\n" + respContent);
        }
    }

    @Override
    public StringToStringMap getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    @Override
    public Attachment[] getRequestAttachments() {
        if (this.response == null || this.response.getRequest() == null) {
            return new Attachment[0];
        }
        return this.response.getRequest().getAttachments();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        if (this.response == null) {
            return null;
        }
        return this.response.getRequestHeaders();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        if (this.response == null) {
            return new Attachment[0];
        }
        return this.response.getAttachments();
    }

    @Override
    public String getResponseContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.response == null) {
            return "<missing response>";
        }
        return this.response.getContentAsString();
    }

    @Override
    public String getRequestContentAsXml() {
        return XmlUtils.seemsToBeXml(this.requestContent) ? this.requestContent : "<not-xml/>";
    }

    @Override
    public String getResponseContentAsXml() {
        if (this.response == null) {
            return null;
        }
        return this.response.getContentAsXml();
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        if (this.response == null) {
            return new StringToStringsMap();
        }
        return this.response.getResponseHeaders();
    }

    @Override
    public long getTimestamp() {
        if (this.isDiscarded() || this.response == null) {
            return -1L;
        }
        return this.response.getTimestamp();
    }

    @Override
    public AssertedXPath[] getAssertedXPathsForResponse() {
        return this.assertedXPaths == null ? new AssertedXPath[]{} : this.assertedXPaths.toArray(new AssertedXPath[this.assertedXPaths.size()]);
    }

    @Override
    public void addAssertedXPath(AssertedXPath assertedXPath) {
        if (this.assertedXPaths == null) {
            this.assertedXPaths = new ArrayList<AssertedXPath>();
        }
        this.assertedXPaths.add(assertedXPath);
    }

    @Override
    public MessageExchange[] getMessageExchanges() {
        return new MessageExchange[]{this};
    }

    @Override
    public byte[] getRawRequestData() {
        return this.response.getRawRequestData();
    }

    @Override
    public byte[] getRawResponseData() {
        return this.response.getRawResponseData();
    }

    @Override
    public Attachment[] getRequestAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public Attachment[] getResponseAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public boolean hasRawData() {
        return this.getRawResponseData() != null || this.getRawRequestData() != null;
    }

    @Override
    public boolean hasRequest(boolean b) {
        return true;
    }

    @Override
    public boolean hasResponse() {
        return this.response != null;
    }
}

