/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestRequestStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.support.RestRequestConverter;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.RestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.teststeps.registry.RestRequestStepFactory;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ChangeRestMethodResolver;
import com.eviware.soapui.support.resolver.ImportInterfaceResolver;
import com.eviware.soapui.support.resolver.RemoveTestStepResolver;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.w3c.dom.Document;

public class RestTestRequestStep
extends WsdlTestStepWithProperties
implements RestTestRequestStepInterface,
Securable {
    private static final Logger log = Logger.getLogger(RestTestRequestStep.class);
    private RestRequestStepConfig restRequestStepConfig;
    private RestTestRequest testRequest;
    private RestResource restResource;
    private RestMethod restMethod;
    private final InternalProjectListener projectListener = new InternalProjectListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private WsdlSubmit<RestRequest> submit;
    private final Map<String, RestTestStepProperty> requestProperties = new HashMap<String, RestTestStepProperty>();

    public RestTestRequestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) throws RestRequestStepFactory.ItemDeletedException {
        super(testCase, config, true, forLoadTest);
        if (((TestStepConfig)this.getConfig()).getConfig() != null) {
            this.restRequestStepConfig = (RestRequestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(RestRequestStepConfig.type);
            this.testRequest = this.buildTestRequest(forLoadTest);
            if (this.testRequest == null) {
                throw new RestRequestStepFactory.ItemDeletedException();
            }
            this.testRequest.addPropertyChangeListener(this);
            this.testRequest.addTestPropertyListener(new InternalTestPropertyListener());
            if (config.isSetName()) {
                this.testRequest.setName(config.getName());
            } else {
                config.setName(this.testRequest.getName());
            }
        } else {
            this.restRequestStepConfig = (RestRequestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(RestRequestStepConfig.type);
        }
        this.refreshRequestProperties();
        this.addProperty(new TestStepBeanProperty("Endpoint", false, this.testRequest, "endpoint", this, false));
        this.addProperty(new TestStepBeanProperty("Username", false, this.testRequest, "username", this, true));
        this.addProperty(new TestStepBeanProperty("Password", false, this.testRequest, "password", this, true));
        this.addProperty(new TestStepBeanProperty("Domain", false, this.testRequest, "domain", this, false));
        this.addProperty(new TestStepBeanProperty("Request", false, this.testRequest, "requestContent", this, true){

            @Override
            public String getDefaultValue() {
                return RestTestRequestStep.this.createDefaultRequestContent();
            }

            @Override
            public SchemaType getSchemaType() {
                String requestContent = RestTestRequestStep.this.getTestRequest().getRequestContent();
                if (XmlUtils.seemsToBeXml(requestContent)) {
                    try {
                        Document dom = XmlUtils.parseXml(requestContent);
                        for (RestRepresentation representation : RestTestRequestStep.this.getTestRequest().getRepresentations(RestRepresentation.Type.REQUEST, RestTestRequestStep.this.getTestRequest().getMediaType())) {
                            if (!representation.getElement().equals(XmlUtils.getQName(dom.getDocumentElement()))) continue;
                            return representation.getSchemaType();
                        }
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                }
                return super.getSchemaType();
            }

            @Override
            public QName getType() {
                return this.getSchemaType().getName();
            }
        });
        this.addProperty(new TestStepBeanProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, true, this.testRequest, "responseContentAsXml", this){

            @Override
            public String getDefaultValue() {
                return RestTestRequestStep.this.createDefaultResponseXmlContent();
            }

            @Override
            public SchemaType getSchemaType() {
                try {
                    Document dom = XmlUtils.parseXml(RestTestRequestStep.this.getTestRequest().getResponseContentAsXml());
                    for (RestRepresentation representation : RestTestRequestStep.this.getTestRequest().getRepresentations(RestRepresentation.Type.RESPONSE, RestTestRequestStep.this.getTestRequest().getResponse().getContentType())) {
                        if (!representation.getElement().equals(XmlUtils.getQName(dom.getDocumentElement()))) continue;
                        return representation.getSchemaType();
                    }
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
                return super.getSchemaType();
            }

            @Override
            public QName getType() {
                return this.getSchemaType().getName();
            }
        });
        this.addProperty(new TestStepBeanProperty("Response", true, this.testRequest, "responseContentAsString", this){

            @Override
            public String getDefaultValue() {
                return RestTestRequestStep.this.createDefaultRawResponseContent();
            }
        });
        this.addProperty(new DefaultTestStepProperty("RawRequest", true, (WsdlTestStep)this){

            @Override
            public String getValue() {
                Response response = RestTestRequestStep.this.testRequest.getResponse();
                return response == null ? null : response.getRequestContent();
            }
        });
        this.initRestTestRequest();
        if (!forLoadTest && this.restResource != null) {
            this.getResource().getService().getProject().addProjectListener(this.projectListener);
            this.getResource().getService().addInterfaceListener(this.interfaceListener);
            this.getResource().getService().addPropertyChangeListener(this);
            this.getResource().addPropertyChangeListener(this);
        }
        if (this.getRestMethod() != null) {
            this.getRestMethod().addPropertyChangeListener(this);
        }
    }

    private void refreshRequestProperties() {
        for (String key : this.requestProperties.keySet()) {
            this.deleteProperty(key, true);
        }
        this.requestProperties.clear();
        for (String key : this.testRequest.getProperties().keySet()) {
            this.requestProperties.put(key, new RestTestStepProperty(key));
            this.addProperty(this.requestProperties.get(key), true);
        }
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.testRequest != null) {
            this.testRequest.beforeSave();
        }
    }

    @Override
    public String getDescription() {
        return this.testRequest == null ? "<missing>" : this.testRequest.getDescription();
    }

    @Override
    public RestRequestStepConfig getRequestStepConfig() {
        return this.restRequestStepConfig;
    }

    protected RestTestRequest buildTestRequest(boolean forLoadTest) {
        if (this.getRestMethod() == null) {
            return null;
        }
        return new RestTestRequest(this.getRestMethod(), this.getRequestStepConfig().getRestRequest(), this, forLoadTest);
    }

    private void initRestTestRequest() {
        if (this.getRestMethod() == null) {
            this.setDisabled(true);
        } else {
            this.getTestRequest().setRestMethod(this.getRestMethod());
        }
    }

    @Override
    public String getService() {
        return this.getRequestStepConfig().getService();
    }

    @Override
    public String getResourcePath() {
        return this.getRequestStepConfig().getResourcePath();
    }

    protected String createDefaultRawResponseContent() {
        return this.getResource() == null ? null : this.getResource().createResponse(true);
    }

    protected String createDefaultResponseXmlContent() {
        return this.getResource() == null ? null : this.getResource().createResponse(true);
    }

    protected String createDefaultRequestContent() {
        return this.getResource() == null ? null : this.getResource().createRequest(true);
    }

    @Override
    public Collection<Interface> getRequiredInterfaces() {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.add(this.findRestResource().getInterface());
        return result;
    }

    private RestResource findRestResource() {
        Project project = ModelSupport.getModelItemProject(this);
        for (Interface iface : project.getInterfaceList()) {
            if (!iface.getName().equals(this.getRequestStepConfig().getService()) || !(iface instanceof RestService)) continue;
            RestService restService = (RestService)iface;
            for (RestResource resource : restService.getResourcesByFullPath(this.getRequestStepConfig().getResourcePath())) {
                if (this.getWsdlModelItemByName(resource.getRestMethodList(), this.getRequestStepConfig().getMethodName()) == null) continue;
                return resource;
            }
        }
        return null;
    }

    private RestMethod findRestMethod() {
        if (!this.restRequestStepConfig.isSetMethodName()) {
            RestRequestConverter.updateRestTestRequest(this);
            if (this.getResource() == null) {
                this.restResource = RestRequestConverter.resolveResource(this);
                if (this.restResource == null) {
                    return null;
                }
                this.getRequestStepConfig().setService(this.restResource.getInterface().getName());
                this.getRequestStepConfig().setResourcePath(this.restResource.getFullPath());
            }
            RestMethod method = RestRequestConverter.getMethod(this.getResource(), this.getRequestStepConfig().getRestRequest().selectAttribute(null, "method").newCursor().getTextValue(), this.getRequestStepConfig().getRestRequest().getName());
            this.restRequestStepConfig.setMethodName(method.getName());
            return method;
        }
        if (this.getResource() == null) {
            this.restResource = RestRequestConverter.resolveResource(this);
            if (this.restResource == null) {
                return null;
            }
            this.getRequestStepConfig().setService(this.restResource.getInterface().getName());
            this.getRequestStepConfig().setResourcePath(this.restResource.getFullPath());
            RestMethod m = (RestMethod)this.getWsdlModelItemByName(this.getResource().getRestMethodList(), this.getRequestStepConfig().getMethodName());
            if (m == null) {
                String mn = null;
                while (mn == null) {
                    mn = UISupport.prompt("Select method in REST Resource [" + this.restResource.getName() + "]", "Missing REST Method", ModelSupport.getNames(this.restResource.getRestMethodList()));
                }
                this.restRequestStepConfig.setMethodName(mn);
                return this.restResource.getRestMethodByName(mn);
            }
        }
        return (RestMethod)this.getWsdlModelItemByName(this.getResource().getRestMethodList(), this.getRequestStepConfig().getMethodName());
    }

    @Override
    public RestMethod getRestMethod() {
        if (this.restMethod == null) {
            this.restMethod = this.findRestMethod();
        }
        return this.restMethod;
    }

    @Override
    public RestResource getResource() {
        if (this.restResource == null) {
            this.restResource = this.findRestResource();
        }
        return this.restResource;
    }

    @Override
    public Operation getOperation() {
        return this.getResource();
    }

    @Override
    public void release() {
        super.release();
        if (this.restResource != null) {
            this.restResource.removePropertyChangeListener(this);
            this.restResource.getService().getProject().removeProjectListener(this.projectListener);
            this.restResource.getService().removeInterfaceListener(this.interfaceListener);
            this.restResource.getService().removePropertyChangeListener(this);
        }
        if (this.restMethod != null) {
            this.restMethod.removePropertyChangeListener(this);
        }
        if (this.testRequest != null) {
            this.testRequest.removePropertyChangeListener(this);
            this.testRequest.release();
        }
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.restRequestStepConfig = (RestRequestStepConfig)config.getConfig().changeType(RestRequestStepConfig.type);
        this.testRequest.updateConfig(this.restRequestStepConfig.getRestRequest());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.testRequest) {
            if (event.getNewValue() instanceof SinglePartHttpResponse) {
                SinglePartHttpResponse response = (SinglePartHttpResponse)event.getNewValue();
                this.firePropertyValueChanged("Response", String.valueOf(response), null);
                String XMLContent = response.getContentAsXml();
                this.firePropertyValueChanged("ResponseAsXml", null, XMLContent);
            }
            if (event.getPropertyName().equals("domain")) {
                this.delegatePropertyChange("Domain", event);
            } else if (event.getPropertyName().equals("password")) {
                this.delegatePropertyChange("Password", event);
            } else if (event.getPropertyName().equals("username")) {
                this.delegatePropertyChange("Username", event);
            } else if (event.getPropertyName().equals("endpoint")) {
                this.delegatePropertyChange("Endpoint", event);
            }
        }
        if (event.getSource() == this.restResource) {
            if (event.getPropertyName().equals("path")) {
                this.getRequestStepConfig().setResourcePath(this.restResource.getFullPath());
            } else if (event.getPropertyName().equals("childMethods") && this.restMethod == event.getOldValue()) {
                log.debug((Object)"Removing test step due to removed Rest method");
                this.getTestCase().removeTestStep(this);
            }
        } else if (this.restResource != null && event.getSource() == this.restResource.getInterface()) {
            if (event.getPropertyName().equals(Interface.NAME_PROPERTY)) {
                this.getRequestStepConfig().setService((String)event.getNewValue());
            }
        } else if (event.getSource() == this.restMethod && event.getPropertyName().equals(RestMethod.NAME_PROPERTY)) {
            this.getRequestStepConfig().setMethodName((String)event.getNewValue());
        }
        if (event.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || event.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) {
            if (this.getTestRequest().getResponse() != null) {
                this.getTestRequest().assertResponse(new WsdlTestRunContext(this));
            }
        } else {
            if (event.getSource() == this.testRequest && event.getPropertyName().equals(WsdlTestRequest.NAME_PROPERTY)) {
                if (!super.getName().equals(event.getNewValue())) {
                    super.setName((String)event.getNewValue());
                }
            } else if (event.getSource() == this.testRequest && event.getPropertyName().equals("restMethod")) {
                this.refreshRequestProperties();
            }
            this.notifyPropertyChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }

    private void delegatePropertyChange(String customPropertyname, PropertyChangeEvent event) {
        this.firePropertyValueChanged(customPropertyname, String.valueOf(event.getOldValue()), String.valueOf(event.getNewValue()));
    }

    @Override
    public boolean dependsOn(AbstractWsdlModelItem<?> modelItem) {
        if (modelItem instanceof Interface && this.getTestRequest().getOperation() != null && this.getTestRequest().getOperation().getInterface() == modelItem) {
            return true;
        }
        return modelItem instanceof Operation && this.getTestRequest().getOperation() == modelItem;
    }

    public void setRestMethod(RestMethod method) {
        if (this.restMethod == method) {
            return;
        }
        RestMethod oldMethod = this.restMethod;
        this.restMethod = method;
        this.getRequestStepConfig().setService(method.getInterface().getName());
        this.getRequestStepConfig().setResourcePath(method.getResource().getFullPath());
        this.getRequestStepConfig().setMethodName(method.getName());
        RestResource res = this.findRestResource();
        if (res != this.getResource()) {
            this.restResource.removePropertyChangeListener(this);
            this.restResource.getService().removeInterfaceListener(this.interfaceListener);
            this.restResource.getService().removePropertyChangeListener(this);
            this.restResource = res;
            this.restResource.getService().addInterfaceListener(this.interfaceListener);
            this.restResource.getService().addPropertyChangeListener(this);
            this.restResource.addPropertyChangeListener(this);
        }
        if (oldMethod != null) {
            oldMethod.removePropertyChangeListener(this);
        }
        this.restMethod.addPropertyChangeListener(this);
        this.getTestRequest().setRestMethod(this.restMethod);
    }

    @Override
    public RestTestRequest getTestRequest() {
        return this.testRequest;
    }

    @Override
    public Interface getInterface() {
        return this.getResource() == null ? null : this.getResource().getInterface();
    }

    @Override
    public ImageIcon getIcon() {
        return this.testRequest == null ? null : this.testRequest.getIcon();
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        if (this.getRestMethod() == null) {
            if (context.hasThisModelItem(this, "Missing REST Method in Project", this.getRequestStepConfig().getService() + "/" + this.getRequestStepConfig().getMethodName())) {
                return;
            }
            context.addPathToResolve(this, "Missing REST Method in Project", this.getRequestStepConfig().getService() + "/" + this.getRequestStepConfig().getMethodName()).addResolvers(new RemoveTestStepResolver(this), new ImportInterfaceResolver(this){

                @Override
                protected boolean update() {
                    RestMethod restMethod = RestTestRequestStep.this.findRestMethod();
                    if (restMethod == null) {
                        return false;
                    }
                    RestTestRequestStep.this.setRestMethod(restMethod);
                    RestTestRequestStep.this.initRestTestRequest();
                    RestTestRequestStep.this.setDisabled(false);
                    return true;
                }
            }, new ChangeRestMethodResolver(this){

                @Override
                public boolean update() {
                    RestMethod restMethod = this.getSelectedRestMethod();
                    if (restMethod == null) {
                        return false;
                    }
                    RestTestRequestStep.this.setRestMethod(restMethod);
                    RestTestRequestStep.this.initRestTestRequest();
                    RestTestRequestStep.this.setDisabled(false);
                    return true;
                }

                @Override
                protected Interface[] getInterfaces(WsdlProject project) {
                    List<RestService> interfaces = ModelSupport.getChildren(project, RestService.class);
                    return interfaces.toArray(new Interface[interfaces.size()]);
                }
            });
        } else {
            this.getRestMethod().resolve(context);
            if (context.hasThisModelItem(this, "Missing REST Method in Project", this.getRequestStepConfig().getService() + "/" + this.getRequestStepConfig().getMethodName())) {
                ResolveContext.PathToResolve path = context.getPath(this, "Missing REST Method in Project", this.getRequestStepConfig().getService() + "/" + this.getRequestStepConfig().getMethodName());
                path.setSolved(true);
            }
        }
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        super.prepare(testRunner, testRunContext);
        this.testRequest.setResponse(null, testRunContext);
        for (TestAssertion assertion : this.testRequest.getAssertionList()) {
            assertion.prepare(testRunner, testRunContext);
        }
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.testRequest == null ? Collections.EMPTY_LIST : this.testRequest.getAssertionList();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this.testRequest);
        result.extractAndAddAll("requestContent");
        result.extractAndAddAll("endpoint");
        result.extractAndAddAll("username");
        result.extractAndAddAll("password");
        result.extractAndAddAll("domain");
        StringToStringsMap requestHeaders = this.testRequest.getRequestHeaders();
        for (Map.Entry headerEntry : requestHeaders.entrySet()) {
            for (String value : (List)headerEntry.getValue()) {
                result.extractAndAddAll(new HttpTestRequestStep.RequestHeaderHolder((String)headerEntry.getKey(), value, this.testRequest), "value");
            }
        }
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public AbstractHttpRequest<?> getHttpRequest() {
        return this.testRequest;
    }

    @Override
    public TestAssertion addAssertion(String type) {
        WsdlMessageAssertion result = this.testRequest.addAssertion(type);
        return result;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.testRequest.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.testRequest.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.testRequest.getAssertableContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.testRequest.getAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.testRequest.getAssertableType();
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.testRequest.getAssertionByName(name);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.testRequest.getAssertionList();
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.testRequest.getAssertionStatus();
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.testRequest.removeAssertion(assertion);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.testRequest.removeAssertionsListener(listener);
    }

    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        return this.testRequest.moveAssertion(ix, offset);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.testRequest.getAssertions();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.testRequest.getAssertionAt(index);
    }

    @Override
    public int getAssertionCount() {
        return this.testRequest == null ? 0 : this.testRequest.getAssertionCount();
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.testRequest.getDefaultAssertableContent();
    }

    @Override
    public String getDefaultSourcePropertyName() {
        Response response = this.testRequest.getResponse();
        return response != null && JsonUtil.seemsToBeJsonContentType(response.getContentType()) ? WsdlTestStepWithProperties.RESPONSE : WsdlTestStepWithProperties.RESPONSE_AS_XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        RestRequestStepResult testStepResult = new RestRequestStepResult(this);
        try {
            this.submit = this.testRequest.submit(runContext, false);
            HttpResponse response = (HttpResponse)this.submit.getResponse();
            if (this.submit.getStatus() != Submit.Status.CANCELED) {
                if (this.submit.getStatus() == Submit.Status.ERROR) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage(this.submit.getError().toString());
                    this.testRequest.setResponse(null, runContext);
                } else if (response == null) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage("Request is missing response");
                    this.testRequest.setResponse(null, runContext);
                } else {
                    runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
                    this.testRequest.setResponse(response, runContext);
                    testStepResult.setTimeTaken(response.getTimeTaken());
                    testStepResult.setSize(response.getContentLength());
                    testStepResult.setResponse(response);
                    switch (this.testRequest.getAssertionStatus()) {
                        case FAILED: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case VALID: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        case UNKNOWN: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                }
            } else {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
                testStepResult.addProperty("URL", response.getURL() == null ? "<missing>" : response.getURL().toString());
                testStepResult.addProperty("Method", String.valueOf(response.getMethod()));
                testStepResult.addProperty("StatusCode", String.valueOf(response.getStatusCode()));
                testStepResult.addProperty("HTTP Version", response.getHttpVersion());
            } else {
                testStepResult.setRequestContent(this.testRequest.getRequestContent());
            }
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
        }
        finally {
            this.submit = null;
        }
        testStepResult.setDomain(PropertyExpander.expandProperties(runContext, this.testRequest.getDomain()));
        testStepResult.setUsername(PropertyExpander.expandProperties(runContext, this.testRequest.getUsername()));
        testStepResult.setEndpoint(PropertyExpander.expandProperties(runContext, this.testRequest.getEndpoint()));
        testStepResult.setPassword(PropertyExpander.expandProperties(runContext, this.testRequest.getPassword()));
        testStepResult.setEncoding(PropertyExpander.expandProperties(runContext, this.testRequest.getEncoding()));
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            Assertable.AssertionStatus assertionStatus = this.testRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        WsdlMessageAssertion assertion = this.getAssertionAt(c);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.testRequest.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.testRequest.setResponse(null, runContext);
            runContext.removeProperty("httpResponse");
        }
        return testStepResult;
    }

    private class RestTestStepProperty
    implements TestStepProperty {
        private String propertyName;

        public RestTestStepProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setPropertyName(String name) {
            this.propertyName = name;
        }

        @Override
        public TestStep getTestStep() {
            return RestTestRequestStep.this;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }

        @Override
        public String getDescription() {
            return RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).getDescription();
        }

        @Override
        public String getValue() {
            return RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).getValue();
        }

        @Override
        public String getDefaultValue() {
            return RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).getDefaultValue();
        }

        @Override
        public void setValue(String value) {
            RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).setValue(value);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public QName getType() {
            return RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).getType();
        }

        @Override
        public ModelItem getModelItem() {
            return RestTestRequestStep.this.getTestRequest();
        }

        @Override
        public boolean isRequestPart() {
            return true;
        }

        @Override
        public SchemaType getSchemaType() {
            return RestTestRequestStep.this.getTestRequest().getProperty(this.propertyName).getSchemaType();
        }
    }

    private class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
            RestTestRequestStep.this.requestProperties.put(name, new RestTestStepProperty(name));
            RestTestRequestStep.this.addProperty((TestProperty)RestTestRequestStep.this.requestProperties.get(name), true);
        }

        @Override
        public void propertyRemoved(String name) {
            RestTestRequestStep.this.requestProperties.remove(name);
            RestTestRequestStep.this.deleteProperty(name, true);
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            RestTestStepProperty prop = (RestTestStepProperty)RestTestRequestStep.this.requestProperties.remove(oldName);
            if (prop != null) {
                prop.setPropertyName(newName);
                RestTestRequestStep.this.requestProperties.put(newName, prop);
            }
            RestTestRequestStep.this.propertyRenamed(oldName);
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            RestTestRequestStep.this.firePropertyValueChanged(name, oldValue, newValue);
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
            RestTestRequestStep.this.firePropertyMoved(name, oldIndex, newIndex);
        }
    }

    public class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        @Override
        public void operationRemoved(Operation operation) {
            if (operation == RestTestRequestStep.this.restResource) {
                log.debug((Object)"Removing test step due to removed operation");
                RestTestRequestStep.this.getTestCase().removeTestStep(RestTestRequestStep.this);
            }
        }

        @Override
        public void operationUpdated(Operation operation) {
            if (operation == RestTestRequestStep.this.restResource) {
                // empty if block
            }
        }
    }

    public class InternalProjectListener
    extends ProjectListenerAdapter {
        @Override
        public void interfaceRemoved(Interface iface) {
            if (RestTestRequestStep.this.restResource != null && RestTestRequestStep.this.restResource.getInterface().equals(iface)) {
                log.debug((Object)"Removing test step due to removed interface");
                RestTestRequestStep.this.getTestCase().removeTestStep(RestTestRequestStep.this);
            }
        }
    }
}

