/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.RunTestCaseRunModeTypeConfig;
import com.eviware.soapui.config.RunTestCaseStepConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageExchangeTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ChooseAnotherTestCase;
import com.eviware.soapui.support.resolver.CreateNewEmptyTestCase;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.resolver.RunTestCaseRemoveResolver;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WsdlRunTestCaseTestStep
extends WsdlTestStep {
    public static final String TARGET_TESTCASE = WsdlRunTestCaseTestStep.class.getName() + "@target_testcase";
    private RunTestCaseStepConfig stepConfig;
    private WsdlTestCaseRunner testCaseRunner;
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private String currentLabel;
    private WsdlTestCase targetTestCase;
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private InternalTestPropertyListener testPropertyListener = new InternalTestPropertyListener();
    private Set<TestRunListener> testRunListeners = new HashSet<TestRunListener>();
    private WsdlTestCase runningTestCase;

    public WsdlRunTestCaseTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (config.getConfig() == null) {
            this.stepConfig = (RunTestCaseStepConfig)config.addNewConfig().changeType(RunTestCaseStepConfig.type);
            this.stepConfig.addNewProperties();
            this.stepConfig.addNewReturnProperties();
        } else {
            this.stepConfig = (RunTestCaseStepConfig)config.getConfig().changeType(RunTestCaseStepConfig.type);
        }
        if (this.stepConfig.getRunMode() == null) {
            this.stepConfig.setRunMode(RunTestCaseRunModeTypeConfig.PARALLELL);
        }
        this.setIcon(UISupport.createImageIcon("/run_test_case_step.png"));
        this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(this, this.stepConfig.getProperties());
    }

    @Override
    public void afterCopy(WsdlTestSuite oldTestSuite, WsdlTestCase oldTestCase) {
        super.afterCopy(oldTestSuite, oldTestCase);
        if (this.targetTestCase != null && oldTestSuite == this.targetTestCase.getTestSuite()) {
            this.setTargetTestCase(this.getTestCase().getTestSuite().getTestCaseByName(this.targetTestCase.getName()));
        }
    }

    @Override
    public void afterLoad() {
        this.setTargetTestCase(this.findTargetTestCase());
        super.afterLoad();
    }

    private void syncProperties() {
        for (String name : this.propertyHolderSupport.getPropertyNames()) {
            if (this.targetTestCase.hasProperty(name)) continue;
            this.propertyHolderSupport.removeProperty(name);
        }
        for (String name : this.targetTestCase.getPropertyNames()) {
            if (this.propertyHolderSupport.hasProperty(name)) continue;
            this.propertyHolderSupport.addProperty(name);
        }
    }

    private WsdlTestCase findTargetTestCase() {
        return (WsdlTestCase)ModelSupport.findModelItemById(this.getTestCaseId(), this.getTestCase().getTestSuite().getProject());
    }

    public StringList getReturnProperties() {
        return new StringList((Collection<?>)this.stepConfig.getReturnProperties().getEntryList());
    }

    public void setReturnProperties(StringList returnProperties) {
        this.stepConfig.getReturnProperties().setEntryArray(returnProperties.toStringArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner testRunner, TestCaseRunContext testRunContext) {
        WsdlMessageExchangeTestStepResult result = new WsdlMessageExchangeTestStepResult(this);
        this.testCaseRunner = null;
        if (this.targetTestCase != null) {
            RunTestCaseRunModeTypeConfig.Enum runMode = this.getRunMode();
            if (runMode == RunTestCaseRunModeTypeConfig.PARALLELL) {
                this.runningTestCase = this.createTestCase(this.targetTestCase);
            } else {
                this.runningTestCase = this.targetTestCase;
                TestCaseRunner targetTestRunner = SoapUI.getTestMonitor().getTestRunner(this.targetTestCase);
                if (targetTestRunner != null && targetTestRunner.getStatus() == TestRunner.Status.RUNNING) {
                    if (runMode == RunTestCaseRunModeTypeConfig.SINGLETON_AND_FAIL) {
                        result.setStatus(TestStepResult.TestStepStatus.FAILED);
                        result.addMessage("Target TestCase is already running");
                        result.stopTimer();
                        this.runningTestCase = null;
                    } else {
                        targetTestRunner.waitUntilFinished();
                    }
                }
            }
            if (this.runningTestCase != null) {
                WsdlTestCase wsdlTestCase = this.runningTestCase;
                synchronized (wsdlTestCase) {
                    for (TestRunListener listener : this.testRunListeners) {
                        this.runningTestCase.addTestRunListener(listener);
                    }
                    StringList returnProperties = this.getReturnProperties();
                    Map<String, TestProperty> props = this.getProperties();
                    for (Map.Entry<String, TestProperty> entry : props.entrySet()) {
                        String value;
                        if (!this.runningTestCase.hasProperty(entry.getKey()) || returnProperties.contains(entry.getKey()) || !StringUtils.hasContent(value = PropertyExpander.expandProperties(testRunContext, entry.getValue().getValue())) && this.isIgnoreEmptyProperties()) continue;
                        this.runningTestCase.setPropertyValue(entry.getKey(), value);
                    }
                    this.currentLabel = this.getLabel();
                    this.runningTestCase.addTestRunListener(this.testRunListener);
                    result.startTimer();
                    StringToObjectMap properties = new StringToObjectMap();
                    if (this.isCopyLoadTestProperties() && properties.containsKey("LoadTestContext")) {
                        properties.put("ThreadIndex", testRunContext.getProperty("ThreadIndex"));
                        properties.put("TotalRunCount", testRunContext.getProperty("TotalRunCount"));
                        properties.put("LoadTestContext", testRunContext.getProperty("LoadTestContext"));
                        properties.put("LoadTestRunner", testRunContext.getProperty("LoadTestRunner"));
                        properties.put("RunCount", testRunContext.getProperty("RunCount"));
                    }
                    if (this.isCopyHttpSession() && testRunContext.hasProperty("#HTTP_STATE")) {
                        properties.put("#HTTP_STATE", testRunContext.getProperty("#HTTP_STATE"));
                    }
                    properties.put("Interactive", testRunContext.getProperty("Interactive"));
                    properties.put("#CallingRunTestCaseStep#", this);
                    properties.put("#CallingTestCaseRunner#", testRunner);
                    properties.put("#CallingTestRunContext#", testRunContext);
                    this.testCaseRunner = this.runningTestCase.run(properties, true);
                    this.testCaseRunner.waitUntilFinished();
                    result.stopTimer();
                    for (String key : returnProperties) {
                        if (!this.runningTestCase.hasProperty(key)) continue;
                        this.setPropertyValue(key, this.runningTestCase.getPropertyValue(key));
                    }
                    for (TestStepResult testStepResult : this.testCaseRunner.getResults()) {
                        result.addMessage(testStepResult.getTestStep().getName() + " - " + (Object)((Object)testStepResult.getStatus()) + " - " + testStepResult.getTimeTaken());
                        for (String msg : testStepResult.getMessages()) {
                            result.addMessage("- " + msg);
                        }
                        if (!(testStepResult instanceof MessageExchangeTestStepResult)) continue;
                        result.addMessages(((MessageExchangeTestStepResult)testStepResult).getMessageExchanges());
                    }
                    switch (this.testCaseRunner.getStatus()) {
                        case CANCELED: {
                            result.setStatus(TestStepResult.TestStepStatus.CANCELED);
                            break;
                        }
                        case FAILED: {
                            result.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case FINISHED: {
                            result.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        default: {
                            result.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                    for (TestRunListener listener : this.testRunListeners) {
                        this.runningTestCase.removeTestRunListener(listener);
                    }
                    if (runMode == RunTestCaseRunModeTypeConfig.PARALLELL) {
                        this.runningTestCase.release();
                    }
                    this.runningTestCase.removeTestRunListener(this.testRunListener);
                    this.runningTestCase = null;
                    this.testCaseRunner = null;
                }
            }
        } else {
            result.setStatus(TestStepResult.TestStepStatus.FAILED);
            result.addMessage("Missing testCase in project");
            result.stopTimer();
        }
        return result;
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        if (this.testCaseRunner != null) {
            name = name + " - [" + (Object)((Object)this.testCaseRunner.getStatus()) + "]";
        }
        if (this.isDisabled()) {
            return name + " (disabled)";
        }
        return name;
    }

    @Override
    public boolean cancel() {
        if (this.testCaseRunner != null) {
            this.testCaseRunner.cancel("Canceled by calling TestCase");
        }
        return true;
    }

    private String getTestCaseId() {
        return this.stepConfig.getTargetTestCase();
    }

    public void setTargetTestCase(WsdlTestCase testCase) {
        if (this.targetTestCase != null) {
            this.targetTestCase.getTestSuite().removeTestSuiteListener(this.testSuiteListener);
            this.targetTestCase.removeTestPropertyListener(this.testPropertyListener);
        }
        WsdlTestCase oldTestCase = this.targetTestCase;
        this.targetTestCase = testCase;
        if (testCase != null) {
            this.stepConfig.setTargetTestCase(testCase.getId());
            this.targetTestCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
            this.targetTestCase.addTestPropertyListener(this.testPropertyListener);
            this.syncProperties();
        }
        this.notifyPropertyChanged(TARGET_TESTCASE, oldTestCase, testCase);
    }

    public boolean isCopyHttpSession() {
        return this.stepConfig.getCopyHttpSession();
    }

    public boolean isCopyLoadTestProperties() {
        return this.stepConfig.getCopyLoadTestProperties();
    }

    public boolean isIgnoreEmptyProperties() {
        return this.stepConfig.getIgnoreEmptyProperties();
    }

    public void setCopyHttpSession(boolean arg0) {
        if (arg0 == this.isCopyHttpSession()) {
            return;
        }
        this.stepConfig.setCopyHttpSession(arg0);
        this.notifyPropertyChanged("copyHttpSession", !arg0, arg0);
    }

    public void setCopyLoadTestProperties(boolean arg0) {
        if (arg0 == this.isCopyLoadTestProperties()) {
            return;
        }
        this.stepConfig.setCopyLoadTestProperties(arg0);
        this.notifyPropertyChanged("copyLoadTestProperties", !arg0, arg0);
    }

    public void setIgnoreEmptyProperties(boolean arg0) {
        if (arg0 == this.isIgnoreEmptyProperties()) {
            return;
        }
        this.stepConfig.setIgnoreEmptyProperties(arg0);
        this.notifyPropertyChanged("ignoreEmptyProperties", !arg0, arg0);
    }

    private WsdlTestCase createTestCase(WsdlTestCase testCase) {
        testCase.beforeSave();
        try {
            TestCaseConfig config = TestCaseConfig.Factory.parse(((TestCaseConfig)testCase.getConfig()).xmlText());
            config.setLoadTestArray(new LoadTestConfig[0]);
            WsdlTestCase wsdlTestCase = testCase.getTestSuite().buildTestCase(config, true);
            wsdlTestCase.afterLoad();
            return wsdlTestCase;
        }
        catch (Throwable e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public XmlBeansPropertiesTestPropertyHolder.PropertiesStepProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    private void updateLabelDuringRun() {
        this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, this.currentLabel, this.getLabel());
        this.currentLabel = this.getLabel();
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.stepConfig = (RunTestCaseStepConfig)config.getConfig().changeType(RunTestCaseStepConfig.type);
        this.propertyHolderSupport.resetPropertiesConfig(this.stepConfig.getProperties());
    }

    @Override
    public void release() {
        if (this.targetTestCase != null) {
            this.targetTestCase.getTestSuite().removeTestSuiteListener(this.testSuiteListener);
            this.targetTestCase.removeTestPropertyListener(this.testPropertyListener);
        }
        super.release();
    }

    public WsdlTestCase getTargetTestCase() {
        return this.targetTestCase;
    }

    public void addTestRunListener(TestRunListener listener) {
        this.testRunListeners.add(listener);
    }

    public void removeTestRunListener(TestRunListener listener) {
        this.testRunListeners.remove(listener);
    }

    public WsdlTestCase getRunningTestCase() {
        return this.runningTestCase;
    }

    public WsdlTestCaseRunner getTestCaseRunner() {
        return this.testCaseRunner;
    }

    public RunTestCaseRunModeTypeConfig.Enum getRunMode() {
        return this.stepConfig.getRunMode();
    }

    public void setRunMode(RunTestCaseRunModeTypeConfig.Enum runMode) {
        this.stepConfig.setRunMode(runMode);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        if (this.targetTestCase == null) {
            if (context.hasThisModelItem(this, "Missing Test Case", this.getTestStepTitle() + "/" + this.stepConfig.getTargetTestCase())) {
                return;
            }
            context.addPathToResolve(this, "Missing Test Case", this.getTestStepTitle() + "/" + this.stepConfig.getTargetTestCase()).addResolvers(new RunTestCaseRemoveResolver(this), new ChooseAnotherTestCase(this), new CreateNewEmptyTestCase(this));
        } else {
            this.targetTestCase.resolve(context);
            if (context.hasThisModelItem(this, "Missing Test Case", this.getTestStepTitle() + "/" + this.stepConfig.getTargetTestCase())) {
                context.getPath(this, "Missing Test Case", this.getTestStepTitle() + "/" + this.stepConfig.getTargetTestCase()).setSolved(true);
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            WsdlRunTestCaseTestStep.this.setTargetTestCase(WsdlRunTestCaseTestStep.this.findTargetTestCase());
        }
    }

    private final class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        @Override
        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlRunTestCaseTestStep.this.updateLabelDuringRun();
        }

        @Override
        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlRunTestCaseTestStep.this.updateLabelDuringRun();
        }

        @Override
        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            WsdlRunTestCaseTestStep.this.updateLabelDuringRun();
        }

        @Override
        public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
            WsdlRunTestCaseTestStep.this.updateLabelDuringRun();
        }
    }

    private final class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
            WsdlRunTestCaseTestStep.this.propertyHolderSupport.addProperty(name);
        }

        @Override
        public void propertyRemoved(String name) {
            WsdlRunTestCaseTestStep.this.propertyHolderSupport.removeProperty(name);
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            WsdlRunTestCaseTestStep.this.propertyHolderSupport.renameProperty(oldName, newName);
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
            WsdlRunTestCaseTestStep.this.propertyHolderSupport.moveProperty(name, newIndex);
        }
    }
}

