/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.ArrayList;

public class SetMockOperationAction
extends AbstractSoapUIAction<WsdlMockResponseTestStep> {
    private XFormDialog dialog;
    private WsdlProject project;

    public SetMockOperationAction() {
        super("Set MockOperation", "Sets which Operation to Mock");
    }

    @Override
    public void perform(WsdlMockResponseTestStep mockResponseTestStep, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(CreateForm.class);
            this.dialog.getFormField("Interface").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    SetMockOperationAction.this.updateOperations(newValue);
                }
            });
        }
        this.project = mockResponseTestStep.getTestCase().getTestSuite().getProject();
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (int c = 0; c < this.project.getInterfaceCount(); ++c) {
            if (this.project.getInterfaceAt(c).getOperationCount() <= 0) continue;
            interfaces.add(this.project.getInterfaceAt(c));
        }
        this.dialog.setOptions("Interface", new ModelItemNames(interfaces).getNames());
        String ifaceName = mockResponseTestStep.getOperation().getInterface().getName();
        this.updateOperations(ifaceName);
        this.dialog.setValue("Interface", ifaceName);
        this.dialog.setValue("Operation", mockResponseTestStep.getOperation().getName());
        if (this.dialog.show()) {
            mockResponseTestStep.setInterface(this.dialog.getValue("Interface"));
            mockResponseTestStep.setOperation(this.dialog.getValue("Operation"));
        }
    }

    private void updateOperations(String interfaceName) {
        WsdlInterface iface = (WsdlInterface)this.project.getInterfaceByName(interfaceName);
        this.dialog.setOptions("Operation", new ModelItemNames<Operation>(iface.getOperationList()).getNames());
    }

    @AForm(description="Set the Operation to mock (required for dispatch and validations)", name="Set MockOperation", helpUrl="/soap-mocking/reference/mockresponse.html", icon="/applications-system.png")
    private static interface CreateForm {
        @AField(description="Specifies the operation to be mocked", name="Operation", type=AField.AFieldType.ENUMERATION)
        public static final String OPERATION = "Operation";
        @AField(description="Specifies the interface containing the operation to be mocked", name="Interface", type=AField.AFieldType.ENUMERATION)
        public static final String INTERFACE = "Interface";
    }
}

