/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.json;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.XPathContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.json.JsonPathAssertionBase;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.JsonPathFacade;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;

public class JsonPathContentAssertion
extends JsonPathAssertionBase
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "JsonPath Match";
    public static final String LABEL = "JsonPath Match";
    public static final String DESCRIPTION = "Uses an JsonPath expression to existence of a node and compares the result to an expected value. Applicable to any property containing JSON.";
    private boolean allowWildcards;

    public static void assertSimilar(String expected, String real, char wildcard) throws ComparisonFailure {
        if (!JsonPathContentAssertion.isSimilar(expected, real, wildcard)) {
            throw new ComparisonFailure("Not matched", expected, real);
        }
    }

    public static boolean isSimilar(String expected, String real, char wildcard) throws ComparisonFailure {
        if (!expected.equals(String.valueOf(wildcard))) {
            StringBuilder sb = new StringBuilder();
            if (expected.startsWith(String.valueOf(wildcard))) {
                sb.append(".*");
            }
            boolean first = true;
            for (String token : expected.split(Pattern.quote(String.valueOf(wildcard)))) {
                if (token.isEmpty()) continue;
                if (!first) {
                    sb.append(".*");
                }
                first = false;
                sb.append(Pattern.quote(token));
            }
            if (expected.endsWith(String.valueOf(wildcard))) {
                sb.append(".*");
            }
            if (!Pattern.compile(sb.toString(), 32).matcher(real).matches()) {
                return false;
            }
        }
        return true;
    }

    public JsonPathContentAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.allowWildcards = reader.readBoolean("allowWildcards", false);
    }

    @Override
    public boolean isAllowWildcards() {
        return this.allowWildcards;
    }

    @Override
    public void setAllowWildcards(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
        this.setConfiguration(this.createConfiguration());
    }

    @Override
    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-json-messages.html";
    }

    @Override
    protected XPathContainsAssertion getAssertion() {
        return this;
    }

    @Override
    public String getConfigurationDialogTitle() {
        return "JSONPath Match Configuration";
    }

    @Override
    public void selectFromCurrent() {
        try {
            String stringValue;
            String assertableContent = this.getAssertable().getAssertableContent();
            if (StringUtils.isNullOrEmpty(assertableContent)) {
                UISupport.showErrorMessage("Missing content to select from");
                return;
            }
            String pathString = this.getPathString();
            PropertyExpansionContext context = this.getPropertyExpansionContext();
            String expandedPath = PropertyExpander.expandProperties(context, pathString.trim());
            JTextArea contentArea = this.getContentArea();
            if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText("");
            }
            if ((stringValue = this.readStringValue(assertableContent, expandedPath)) == null) {
                UISupport.showErrorMessage("No match in current response");
            } else if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText(stringValue);
            } else {
                this.setExpectedContent(stringValue, false);
            }
        }
        catch (Throwable e) {
            UISupport.showErrorMessage("Invalid JsonPath expression.");
            SoapUI.logError(e);
        }
    }

    @Override
    public String assertContent(String assertableContent, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.getPath() == null) {
                return "Missing path for JsonPath assertion";
            }
            if (this.getExpectedContent() == null) {
                return "Missing content for JsonPath assertion";
            }
            String expandedPath = PropertyExpander.expandProperties(context, this.getPath());
            JsonPathFacade jsonPathFacade = new JsonPathFacade(assertableContent);
            String result = jsonPathFacade.readStringValue(expandedPath);
            String expandedResult = PropertyExpander.expandProperties(context, result);
            String expandedContent = PropertyExpander.expandProperties(context, this.getExpectedContent());
            if (this.allowWildcards) {
                JsonPathContentAssertion.assertSimilar(expandedContent, expandedResult, '*');
            } else {
                Assert.assertEquals((String)expandedContent, (String)expandedResult);
            }
        }
        catch (Throwable exception) {
            this.throwAssertionException(this.getPath(), exception);
        }
        return type + " matches content for [" + this.getPath() + "]";
    }

    public static class Factory
    extends JsonPathAssertionBase.JsonAssertionFactory {
        public Factory() {
            super("JsonPath Match", "JsonPath Match", JsonPathContentAssertion.DESCRIPTION, JsonPathContentAssertion.class);
        }
    }
}

