/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.json;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.XPathContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.json.JsonPathAssertionBase;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.JsonPathFacade;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.util.List;
import javax.swing.JTextArea;
import junit.framework.Assert;

public class JsonPathCountAssertion
extends JsonPathAssertionBase
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "JsonPath Count";
    public static final String LABEL = "JsonPath Count";
    public static final String DESCRIPTION = "Uses an JsonPath expression to count the occurrences of an element. Applicable to any property containing JSON.";

    public JsonPathCountAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
    }

    @Override
    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-json-messages.html";
    }

    @Override
    protected XPathContainsAssertion getAssertion() {
        return this;
    }

    @Override
    public String getConfigurationDialogTitle() {
        return "JSONPath Count Match Configuration";
    }

    @Override
    public void selectFromCurrent() {
        try {
            Object result;
            String assertableContent = this.getAssertable().getAssertableContent();
            if (StringUtils.isNullOrEmpty(assertableContent)) {
                UISupport.showErrorMessage("Missing content to select from");
                return;
            }
            String pathString = this.getPathString();
            PropertyExpansionContext context = this.getPropertyExpansionContext();
            String expandedPath = PropertyExpander.expandProperties(context, pathString.trim());
            JTextArea contentArea = this.getContentArea();
            if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText("");
            }
            if ((result = new JsonPathFacade(assertableContent).readObjectValue(expandedPath)) == null) {
                UISupport.showErrorMessage("No match in current response");
            } else {
                Integer count = this.getResultSize(result);
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText(count.toString());
                } else {
                    this.setExpectedContent(count.toString(), false);
                }
            }
        }
        catch (Throwable e) {
            UISupport.showErrorMessage("Invalid JsonPath expression.");
            SoapUI.logError(e);
        }
    }

    private Integer getResultSize(Object result) {
        Integer count = 0;
        if (result instanceof List) {
            count = ((List)result).size();
        } else if (result != null) {
            count = 1;
        }
        return count;
    }

    @Override
    public String assertContent(String assertableContent, SubmitContext context, String type) throws AssertionException {
        String path = this.getPath();
        try {
            if (path == null) {
                return "Missing path for JsonPath assertion";
            }
            if (this.getExpectedContent() == null) {
                return "Missing content for JsonPath assertion";
            }
            String expandedPath = PropertyExpander.expandProperties(context, path);
            Object result = new JsonPathFacade(assertableContent).readObjectValue(expandedPath);
            String resultSize = this.getResultSize(result).toString();
            String expandedContent = PropertyExpander.expandProperties(context, this.getExpectedContent());
            Assert.assertEquals((String)expandedContent, (String)resultSize);
        }
        catch (Throwable exception) {
            this.throwAssertionException(path, exception);
        }
        return type + " matches content for [" + path + "]";
    }

    public static class Factory
    extends JsonPathAssertionBase.JsonAssertionFactory {
        public Factory() {
            super("JsonPath Count", "JsonPath Count", JsonPathCountAssertion.DESCRIPTION, JsonPathCountAssertion.class);
        }
    }
}

