/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.util;

import com.eviware.soapui.impl.rest.mock.RestMockAction;
import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.UISupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ModelItemIconFactory {
    private static Map<Class<? extends ModelItem>, String> modelItemIcons = new HashMap<Class<? extends ModelItem>, String>();

    public static ImageIcon getIcon(Class<? extends ModelItem> clazz) {
        if (modelItemIcons.containsKey(clazz)) {
            return UISupport.createImageIcon(modelItemIcons.get(clazz));
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!modelItemIcons.containsKey(iface)) continue;
            return UISupport.createImageIcon(modelItemIcons.get(iface));
        }
        return null;
    }

    public static String getIconPath(Class<? extends ModelItem> clazz) {
        if (modelItemIcons.containsKey(clazz)) {
            return modelItemIcons.get(clazz);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!modelItemIcons.containsKey(iface)) continue;
            return modelItemIcons.get(iface);
        }
        if (clazz.getSuperclass() != null && ModelItem.class.isAssignableFrom(clazz.getSuperclass())) {
            return ModelItemIconFactory.getIconPath(clazz.getSuperclass());
        }
        return null;
    }

    public static <T extends ModelItem> String getIconPath(T modelItem) {
        return ModelItemIconFactory.getIconPath(modelItem.getClass());
    }

    public static <T extends ModelItem> ImageIcon getIcon(T modelItem) {
        return ModelItemIconFactory.getIcon(modelItem.getClass());
    }

    static {
        modelItemIcons.put(Project.class, "/project.png");
        modelItemIcons.put(TestSuite.class, "/test_suite.png");
        modelItemIcons.put(TestCase.class, "/testcase.png");
        modelItemIcons.put(LoadTest.class, "/loadTest.png");
        modelItemIcons.put(MockService.class, "/soap_virt.png");
        modelItemIcons.put(MockResponse.class, "/mockResponse.gif");
        modelItemIcons.put(MockOperation.class, "/mockOperation.gif");
        modelItemIcons.put(RestMockService.class, "/rest_virt.png");
        modelItemIcons.put(RestMockAction.class, RestMockAction.getDefaultIcon());
        modelItemIcons.put(RestMockResponse.class, "/restMockResponse.gif");
        modelItemIcons.put(Operation.class, "/operation.png");
        modelItemIcons.put(SecurityTest.class, "/security_test.gif");
        modelItemIcons.put(TestStep.class, "/teststeps.gif");
        modelItemIcons.put(TestAssertion.class, "/assertions.png");
        modelItemIcons.put(Request.class, "/soap_request.png");
        modelItemIcons.put(Interface.class, "/interface.png");
    }
}

