/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.iface.SoapUIListener;
import com.eviware.soapui.plugins.ActionConfiguration;
import com.eviware.soapui.plugins.ActionConfigurations;
import com.eviware.soapui.plugins.ActionGroup;
import com.eviware.soapui.plugins.ActionMapping;
import com.eviware.soapui.plugins.FactoryConfiguration;
import com.eviware.soapui.plugins.JarClassLoader;
import com.eviware.soapui.plugins.ListenerConfiguration;
import com.eviware.soapui.plugins.PluginProxies;
import com.eviware.soapui.plugins.SoapUIFactory;
import com.eviware.soapui.plugins.auto.AutoFactory;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionGroup;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.action.support.DefaultActionMapping;
import com.eviware.soapui.support.action.support.DefaultSoapUIActionGroup;
import com.eviware.soapui.support.action.support.StandaloneActionMapping;
import com.eviware.soapui.support.action.support.WrapperSoapUIAction;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.listener.ListenerRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.apache.commons.lang.ObjectUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.adapters.JavaReflectionAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderBase {
    private static Logger logger = LoggerFactory.getLogger(LoaderBase.class);
    protected SoapUIFactoryRegistry factoryRegistry;
    protected SoapUIActionRegistry actionRegistry;
    protected ListenerRegistry listenerRegistry;

    public LoaderBase(ListenerRegistry listenerRegistry, SoapUIActionRegistry actionRegistry, SoapUIFactoryRegistry factoryRegistry) {
        this.listenerRegistry = listenerRegistry;
        this.actionRegistry = actionRegistry;
        this.factoryRegistry = factoryRegistry;
    }

    protected Collection<? extends SoapUIFactory> loadFactories(Reflections jarFileScanner) throws IllegalAccessException, InstantiationException {
        HashSet<SoapUIFactory> factories = new HashSet<SoapUIFactory>();
        Set factoryClasses = jarFileScanner.getTypesAnnotatedWith(FactoryConfiguration.class);
        for (Class factoryClass : factoryClasses) {
            if (!SoapUIFactory.class.isAssignableFrom(factoryClass)) {
                logger.warn("Class " + factoryClass + " is annotated with @FactoryConfiguration " + "but does not implement SoapUIFactory");
                continue;
            }
            factories.add(this.createFactory(factoryClass));
        }
        this.loadAutoFactories(jarFileScanner, factories);
        return this.registerFactories(factories);
    }

    protected SoapUIFactory createFactory(Class<SoapUIFactory> factoryClass) throws InstantiationException, IllegalAccessException {
        return this.createObject(factoryClass);
    }

    protected <T> T createObject(Class<T> objectClass) throws IllegalAccessException, InstantiationException {
        return PluginProxies.proxyIfApplicable(objectClass.newInstance());
    }

    protected Collection<? extends SoapUIFactory> registerFactories(Collection<? extends SoapUIFactory> factories) {
        for (SoapUIFactory soapUIFactory : factories) {
            this.factoryRegistry.addFactory(soapUIFactory.getFactoryType(), soapUIFactory);
        }
        return factories;
    }

    protected void loadAutoFactories(Reflections jarFileScanner, Collection<SoapUIFactory> factories) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addUrls(new URL[]{ClasspathHelper.forClass(AutoFactory.class, (ClassLoader[])new ClassLoader[0])});
        builder.setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        builder.addClassLoader(Thread.currentThread().getContextClassLoader());
        Reflections autoAnnotationFinder = new Reflections((Configuration)builder);
        for (Class clazz : autoAnnotationFinder.getTypesAnnotatedWith(AutoFactory.class)) {
            if (!clazz.isAnnotation() || !clazz.getSimpleName().startsWith("Plugin")) continue;
            try {
                String className = "Auto" + clazz.getSimpleName().substring(6) + "Factory";
                Class<?> factoryClass = Class.forName(clazz.getPackage().getName() + ".factories." + className);
                factories.addAll(this.findAutoFactoryObjects(jarFileScanner, clazz, factoryClass));
            }
            catch (ClassNotFoundException e) {
                SoapUI.logError(e);
            }
        }
    }

    protected Collection<SoapUIFactory> findAutoFactoryObjects(Reflections jarFileScanner, Class<? extends Annotation> annotationType, Class<? extends SoapUIFactory> factoryClass) {
        HashSet<SoapUIFactory> factories = new HashSet<SoapUIFactory>();
        Set objectClasses = jarFileScanner.getTypesAnnotatedWith(annotationType);
        for (Class clazz : objectClasses) {
            try {
                Annotation annotation = clazz.getAnnotation(annotationType);
                factories.add(this.createAutoFactory(annotationType, factoryClass, clazz, annotation));
                SoapUI.log("Added AutoFactory for [" + annotationType.getSimpleName() + "]");
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return factories;
    }

    protected SoapUIFactory createAutoFactory(Class<? extends Annotation> annotationType, Class<? extends SoapUIFactory> factoryClass, Class<?> clazz, Annotation annotation) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return factoryClass.getConstructor(annotationType, clazz.getClass()).newInstance(annotation, clazz);
    }

    protected List<Class<? extends SoapUIListener>> registerListeners(List<Class<? extends SoapUIListener>> listeners) {
        Iterator<Class<? extends SoapUIListener>> i$ = listeners.iterator();
        while (i$.hasNext()) {
            Class<? extends SoapUIListener> listenerClass;
            for (Class<? extends SoapUIListener> currentListenerClass = listenerClass = i$.next(); currentListenerClass != null; currentListenerClass = currentListenerClass.getSuperclass()) {
                for (Class<?> implementedInterface : currentListenerClass.getInterfaces()) {
                    if (!SoapUIListener.class.isAssignableFrom(implementedInterface)) continue;
                    this.listenerRegistry.addListener(implementedInterface, listenerClass, null);
                }
            }
        }
        return listeners;
    }

    protected List<Class<? extends SoapUIListener>> loadListeners(Reflections jarFileScanner) throws IllegalAccessException, InstantiationException {
        ArrayList<Class<? extends SoapUIListener>> listeners = new ArrayList<Class<? extends SoapUIListener>>();
        Set listenerClasses = jarFileScanner.getTypesAnnotatedWith(ListenerConfiguration.class);
        for (Class listenerClass : listenerClasses) {
            if (!SoapUIListener.class.isAssignableFrom(listenerClass)) {
                logger.warn("Class " + listenerClass + " is annotated with @ListenerConfiguration " + "but does not implement SoapUIListener");
                continue;
            }
            listeners.add(listenerClass);
        }
        return this.registerListeners(listeners);
    }

    protected List<? extends SoapUIAction> registerActions(List<? extends SoapUIAction> actions) {
        Collections.sort(actions, new Comparator<SoapUIAction>(){

            @Override
            public int compare(SoapUIAction o1, SoapUIAction o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (SoapUIAction soapUIAction : actions) {
            ActionConfigurations configurations;
            this.actionRegistry.addAction(soapUIAction.getId(), soapUIAction);
            ActionConfiguration configuration = PluginProxies.getAnnotation(soapUIAction, ActionConfiguration.class);
            if (configuration != null) {
                this.configureAction(soapUIAction, configuration);
            }
            if ((configurations = PluginProxies.getAnnotation(soapUIAction, ActionConfigurations.class)) == null) continue;
            for (ActionConfiguration config : configurations.configurations()) {
                this.configureAction(soapUIAction, config);
            }
        }
        return actions;
    }

    protected List<? extends SoapUIActionGroup> registerActionGroups(List<SoapUIActionGroup> actionGroups) {
        for (SoapUIActionGroup actionGroup : actionGroups) {
            this.actionRegistry.addActionGroup(actionGroup);
        }
        return actionGroups;
    }

    protected List<? extends SoapUIActionGroup> loadActionGroups(Reflections jarFileScanner) throws InstantiationException, IllegalAccessException {
        ArrayList<SoapUIActionGroup> actionGroups = new ArrayList<SoapUIActionGroup>();
        Set actionGroupClasses = jarFileScanner.getTypesAnnotatedWith(ActionGroup.class);
        for (Class actionGroupClass : actionGroupClasses) {
            if (!SoapUIActionGroup.class.isAssignableFrom(actionGroupClass)) {
                logger.warn("Class " + actionGroupClass + " is annotated with @ActionGroup " + "but does not implement SoapUIActionGroup");
                continue;
            }
            ActionGroup annotation = actionGroupClass.getAnnotation(ActionGroup.class);
            SoapUIActionGroup actionGroup = this.createActionGroup(actionGroupClass);
            for (ActionMapping mapping : annotation.actions()) {
                try {
                    if (mapping.type() == ActionMapping.Type.SEPARATOR) {
                        actionGroup.addMapping("SeperatorAction", SoapUIActionRegistry.SeperatorAction.getDefaultMapping());
                        continue;
                    }
                    if (mapping.type() == ActionMapping.Type.GROUP || mapping.type() == ActionMapping.Type.INSERT) {
                        SoapUIActionRegistry.SoapUIActionGroupAction actionListAction = new SoapUIActionRegistry.SoapUIActionGroupAction(mapping.name(), mapping.description(), mapping.groupId());
                        actionListAction.setInsert(mapping.type() == ActionMapping.Type.INSERT);
                        StandaloneActionMapping actionMapping = new StandaloneActionMapping(actionListAction);
                        actionGroup.addMapping(mapping.groupId(), actionMapping);
                        continue;
                    }
                    if (mapping.type() != ActionMapping.Type.ACTION) continue;
                    Class<? extends Object> actionClass = mapping.actionClass();
                    String actionId = mapping.actionId();
                    if (actionClass != ObjectUtils.Null.class) {
                        if (SoapUIAction.class.isAssignableFrom(actionClass)) {
                            SoapUIAction action = this.createAction(actionClass);
                            this.actionRegistry.addAction(action.getId(), action);
                            actionId = action.getId();
                        } else if (Action.class.isAssignableFrom(actionClass)) {
                            Action swingAction = (Action)this.createObject(actionClass);
                            WrapperSoapUIAction action = new WrapperSoapUIAction(swingAction);
                            this.actionRegistry.addAction(action.getId(), action);
                            actionId = action.getId();
                        }
                    }
                    DefaultActionMapping actionMapping = new DefaultActionMapping(actionId, mapping.keyStroke(), mapping.iconPath(), actionId.equals(annotation.defaultAction()), mapping.param());
                    actionMapping.setToolbarAction(mapping.isToolbarAction());
                    actionMapping.setToolbarIndex(mapping.toolbarIndex());
                    if (!mapping.name().equals("")) {
                        actionMapping.setName(mapping.name());
                    }
                    if (!mapping.description().equals("")) {
                        actionMapping.setDescription(mapping.description());
                    }
                    actionGroup.addMapping(actionId, actionMapping);
                }
                catch (Throwable e) {
                    logger.error("Error adding actionMapping", e);
                }
            }
            actionGroups.add(actionGroup);
        }
        return this.registerActionGroups(actionGroups);
    }

    protected List<? extends SoapUIAction> loadActions(Reflections jarFileScanner) throws InstantiationException, IllegalAccessException {
        ArrayList<SoapUIAction> actions = new ArrayList<SoapUIAction>();
        Set actionClasses = jarFileScanner.getTypesAnnotatedWith(ActionConfiguration.class);
        for (Class actionClass : actionClasses) {
            if (!SoapUIAction.class.isAssignableFrom(actionClass)) {
                logger.error("Class " + actionClass + " is annotated with @ActionConfiguration " + "but does not implement SoapUIAction");
                continue;
            }
            actions.add(this.createAction(actionClass));
        }
        actionClasses = jarFileScanner.getTypesAnnotatedWith(ActionConfigurations.class);
        for (Class actionClass : actionClasses) {
            if (!SoapUIAction.class.isAssignableFrom(actionClass)) {
                logger.error("Class " + actionClass + " is annotated with @ActionConfigurations " + "but does not implement SoapUIAction");
                continue;
            }
            actions.add(this.createAction(actionClass));
        }
        return this.registerActions(actions);
    }

    protected SoapUIAction createAction(Class<SoapUIAction> actionClass) throws InstantiationException, IllegalAccessException {
        return this.createObject(actionClass);
    }

    protected SoapUIActionGroup createActionGroup(Class<SoapUIActionGroup> actionGroupClass) throws InstantiationException, IllegalAccessException {
        return this.createObject(actionGroupClass);
    }

    protected void configureAction(SoapUIAction action, ActionConfiguration configuration) {
        String groupId = configuration.actionGroup();
        SoapUIActionGroup targetGroup = this.actionRegistry.getActionGroup(groupId);
        if (targetGroup == null) {
            targetGroup = new DefaultSoapUIActionGroup(groupId, groupId);
            this.actionRegistry.addActionGroup(targetGroup);
        }
        DefaultActionMapping mapping = new DefaultActionMapping(action.getId(), configuration.keyStroke(), configuration.iconPath(), configuration.defaultAction(), null);
        mapping.setName(action.getName());
        mapping.setDescription(configuration.description());
        mapping.setToolbarAction(configuration.isToolbarAction());
        int insertIndex = -1;
        if (StringUtils.hasContent(configuration.beforeAction())) {
            insertIndex = targetGroup.getMappingIndex(configuration.beforeAction());
        } else if (StringUtils.hasContent(configuration.afterAction())) {
            insertIndex = targetGroup.getMappingIndex(configuration.afterAction()) + 1;
        }
        if (configuration.separatorBefore()) {
            targetGroup.addMapping("SeperatorAction", insertIndex++, SoapUIActionRegistry.SeperatorAction.getDefaultMapping());
        }
        targetGroup.addMapping(action.getId(), insertIndex, mapping);
        if (configuration.separatorAfter()) {
            targetGroup.addMapping("SeperatorAction", ++insertIndex, SoapUIActionRegistry.SeperatorAction.getDefaultMapping());
        }
    }

    protected void unregisterListeners(List<Class<? extends SoapUIListener>> listeners) {
        for (Class<? extends SoapUIListener> listenerClass : listeners) {
            for (Class<?> implementedInterface : listenerClass.getInterfaces()) {
                if (!SoapUIListener.class.isAssignableFrom(implementedInterface)) continue;
                this.listenerRegistry.removeListener(implementedInterface, listenerClass);
                this.listenerRegistry.removeSingletonListener(implementedInterface, listenerClass);
            }
        }
    }

    protected void unregisterFactories(Collection<? extends SoapUIFactory> factories) {
        for (SoapUIFactory soapUIFactory : factories) {
            this.factoryRegistry.removeFactory(soapUIFactory.getFactoryType(), soapUIFactory);
        }
    }

    protected void unregisterActions(List<? extends SoapUIAction> actions) {
        for (SoapUIAction soapUIAction : actions) {
            this.actionRegistry.removeAction(soapUIAction.getId());
        }
    }

    private boolean isToolbarAction(SoapUIAction soapUIAction) {
        ActionConfiguration annotation = PluginProxies.getAnnotation(soapUIAction, ActionConfiguration.class);
        return annotation != null && StringUtils.hasContent(annotation.toolbarIcon());
    }

    protected static class GroovyAndJavaReflectionAdapter
    extends JavaReflectionAdapter {
        private final JarClassLoader jarClassLoader;

        public GroovyAndJavaReflectionAdapter(JarClassLoader jarClassLoader) {
            this.jarClassLoader = jarClassLoader;
        }

        public Class getOfCreateClassObject(Vfs.File file) throws Exception {
            if (file.getName().endsWith(".groovy")) {
                return this.jarClassLoader.loadScriptClass(file.getRelativePath());
            }
            return super.getOfCreateClassObject(file, new ClassLoader[]{this.jarClassLoader});
        }
    }

    protected static class TypeAnnotationsScanner
    extends org.reflections.scanners.TypeAnnotationsScanner {
        protected TypeAnnotationsScanner() {
        }

        public boolean acceptsInput(String file) {
            if (file.endsWith(".groovy")) {
                return true;
            }
            return super.acceptsInput(file);
        }
    }
}

