/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.plugins.PluginClassLoader;
import com.eviware.soapui.plugins.PluginProxy;
import com.eviware.soapui.plugins.UsePluginClassloader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginProxies {
    private static final Method OBJECT_EQUALS_METHOD = PluginProxies.getObjectEqualsMethod();
    private static final Logger log = LoggerFactory.getLogger(PluginProxies.class);

    private static Method getObjectEqualsMethod() {
        try {
            return Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Object.equals() not found!");
        }
    }

    public static <T> T proxyIfApplicable(T delegate) {
        if (PluginProxies.loadedFromPluginJar(delegate)) {
            return PluginProxies.createProxyFor(delegate);
        }
        return delegate;
    }

    static <T> T createProxyFor(T delegate) {
        if (delegate instanceof JComponent) {
            log.warn("Can't proxy JComponent derived classes");
            return delegate;
        }
        List interfaces = ClassUtils.getAllInterfaces(delegate.getClass());
        if (interfaces.isEmpty()) {
            log.warn("Can't proxy instance of {} because the class doesn't implement any interfaces", delegate.getClass());
            return delegate;
        }
        interfaces.add(PluginProxy.class);
        return (T)Proxy.newProxyInstance(PluginProxies.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), new DelegatingHandler<T>(delegate));
    }

    public static <T> Collection<T> proxyInstancesWhereApplicable(Collection<T> instancesToProxy) {
        HashSet<T> proxiedInstances = new HashSet<T>();
        for (T instance : instancesToProxy) {
            proxiedInstances.add(PluginProxies.proxyIfApplicable(instance));
        }
        return proxiedInstances;
    }

    public static <T extends Annotation> T getAnnotation(Object possiblyProxiedObject, Class<T> annotationClass) {
        if (possiblyProxiedObject == null) {
            return null;
        }
        if (possiblyProxiedObject instanceof Class) {
            return ((Class)possiblyProxiedObject).getAnnotation(annotationClass);
        }
        T annotation = possiblyProxiedObject.getClass().getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return possiblyProxiedObject instanceof PluginProxy ? (T)((PluginProxy)possiblyProxiedObject).getProxiedClassAnnotation(annotationClass) : null;
    }

    private static <T> boolean loadedFromPluginJar(T delegate) {
        return delegate != null && delegate.getClass().getClassLoader() instanceof PluginClassLoader;
    }

    private static class DelegatingHandler<T>
    implements InvocationHandler {
        private T innerObject;

        public DelegatingHandler(T innerObject) {
            this.innerObject = innerObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(OBJECT_EQUALS_METHOD)) {
                return this.equalsInternal(args[0]);
            }
            if (method.getName().equals("hashCode")) {
                return this.innerObject.hashCode();
            }
            if (method.getDeclaringClass().equals(PluginProxy.class) && method.getName().equals("getProxiedClassAnnotation")) {
                return this.innerObject.getClass().getAnnotation((Class)args[0]);
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.shouldUsePluginClassloaderFor(method)) {
                Thread.currentThread().setContextClassLoader(this.innerObject.getClass().getClassLoader());
            }
            try {
                Object returnValue = method.invoke(this.innerObject, args);
                Object object = PluginProxies.proxyIfApplicable(returnValue);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }

        private boolean shouldUsePluginClassloaderFor(Method method) {
            try {
                return method.getAnnotation(UsePluginClassloader.class) != null || method.getDeclaringClass().getAnnotation(UsePluginClassloader.class) != null || this.innerObject.getClass().getAnnotation(UsePluginClassloader.class) != null || this.innerObject.getClass().getMethod(method.getName(), method.getParameterTypes()).getAnnotation(UsePluginClassloader.class) != null;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        private boolean equalsInternal(Object other) {
            if (other == null) {
                return false;
            }
            Object actualOtherObject = null;
            if (Proxy.isProxyClass(other.getClass())) {
                InvocationHandler handler = Proxy.getInvocationHandler(other);
                if (handler instanceof DelegatingHandler) {
                    actualOtherObject = ((DelegatingHandler)handler).innerObject;
                }
            } else {
                actualOtherObject = other;
            }
            return this.innerObject.equals(actualOtherObject);
        }
    }
}

