/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.log;

import com.eviware.soapui.model.testsuite.TestStepResult;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.collections.list.TreeList;

public class FunctionalTestLogModel
extends AbstractListModel {
    private List<Object> items = Collections.synchronizedList(new TreeList());
    private List<SoftReference<TestStepResult>> results = Collections.synchronizedList(new TreeList());
    private int maxSize = 100;
    private int stepCount;

    @Override
    public synchronized Object getElementAt(int arg0) {
        try {
            return this.items.get(arg0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    public synchronized void addText(String msg) {
        this.items.add(msg);
        this.results.add(null);
        this.fireIntervalAdded(this, this.items.size() - 1, this.items.size() - 1);
        this.enforceMaxSize();
    }

    public synchronized TestStepResult getTestStepResultAt(int index) {
        if (index >= this.results.size()) {
            return null;
        }
        SoftReference<TestStepResult> result = this.results.get(index);
        return result == null ? null : result.get();
    }

    public synchronized void addSecurityTestFunctionalStepResult(TestStepResult result) {
        ++this.stepCount;
        int size = this.items.size();
        SoftReference<TestStepResult> stepResultRef = new SoftReference<TestStepResult>(result);
        this.items.add("Step " + this.stepCount + " [" + result.getTestStep().getName() + "] " + (Object)((Object)result.getStatus()) + ": took " + result.getTimeTaken() + " ms");
        this.results.add(stepResultRef);
        for (String msg : result.getMessages()) {
            this.items.add(" -> " + msg);
            this.results.add(stepResultRef);
        }
        this.fireIntervalAdded(this, size, this.items.size() - 1);
        this.enforceMaxSize();
    }

    public synchronized void clear() {
        int sz = this.items.size();
        this.items.clear();
        this.results.clear();
        this.stepCount = 0;
        this.fireIntervalRemoved(this, 0, sz);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.enforceMaxSize();
    }

    private synchronized void enforceMaxSize() {
        while (this.items.size() > this.maxSize) {
            this.items.remove(0);
            this.results.remove(0);
            this.fireIntervalRemoved(this, 0, 0);
        }
    }
}

