/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.config.MaliciousAttachmentConfig;
import com.eviware.soapui.config.MaliciousAttachmentElementConfig;
import com.eviware.soapui.config.MaliciousAttachmentSecurityScanConfig;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.security.support.MaliciousAttachmentListToTableHolder;
import com.eviware.soapui.security.tools.AttachmentElement;
import com.eviware.soapui.support.UISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MaliciousAttachmentFilesListForm
extends JPanel {
    private DefaultListModel listModel;
    private JList list;
    private AttachmentElement oldSelection;
    private AttachmentElement currentSelection;
    private MaliciousAttachmentSecurityScanConfig config;
    final MaliciousAttachmentListToTableHolder holder;

    public MaliciousAttachmentFilesListForm(MaliciousAttachmentSecurityScanConfig config, MaliciousAttachmentListToTableHolder holder) {
        super(new BorderLayout());
        this.config = config;
        this.holder = holder;
        JPanel p = UISupport.createEmptyPanel(3, 3, 3, 3);
        p.add((Component)new JLabel("<html><b>Existing Attachments</b></html>"), "West");
        this.add((Component)p, "North");
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setToolTipText("Choose file");
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(30, 50));
        this.add((Component)scrollPane, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MaliciousAttachmentFilesListForm.this.currentSelection = MaliciousAttachmentFilesListForm.this.list.getSelectedIndex() == -1 ? null : (AttachmentElement)MaliciousAttachmentFilesListForm.this.listModel.get(MaliciousAttachmentFilesListForm.this.list.getSelectedIndex());
                MaliciousAttachmentFilesListForm.this.holder.refresh(MaliciousAttachmentFilesListForm.this.oldSelection, MaliciousAttachmentFilesListForm.this.currentSelection);
                MaliciousAttachmentFilesListForm.this.oldSelection = MaliciousAttachmentFilesListForm.this.currentSelection;
            }
        });
        this.setBorder(null);
    }

    public AttachmentElement getFirstItem() {
        if (this.list.getModel().getSize() != 0) {
            this.list.setSelectedIndex(0);
            return (AttachmentElement)this.list.getSelectedValue();
        }
        return null;
    }

    public JList getList() {
        return this.list;
    }

    public AttachmentElement[] getData() {
        AttachmentElement[] result = new AttachmentElement[this.listModel.size()];
        for (int c = 0; c < result.length; ++c) {
            result[c] = (AttachmentElement)this.listModel.get(c);
        }
        return result;
    }

    public void setData(Attachment[] attachments) {
        MaliciousAttachmentSecurityScanConfig copy = (MaliciousAttachmentSecurityScanConfig)this.config.copy();
        this.listModel.clear();
        this.config.getElementList().clear();
        this.holder.getGenerateTableModel().clear();
        this.holder.getReplaceTableModel().clear();
        this.holder.getTablesDialog().setBooleanValue("Remove", new Boolean(false));
        if (attachments != null) {
            block0: for (Attachment att : attachments) {
                AttachmentElement attEl = new AttachmentElement(att, att.getId());
                this.listModel.addElement(attEl);
                this.holder.getGenerateTableModel().clear();
                this.holder.getReplaceTableModel().clear();
                this.holder.getTablesDialog().setBooleanValue("Remove", new Boolean(false));
                MaliciousAttachmentElementConfig newElement = this.config.addNewElement();
                newElement.setKey(attEl.getId());
                for (MaliciousAttachmentElementConfig element : copy.getElementList()) {
                    MaliciousAttachmentConfig newEl;
                    if (!attEl.getId().equals(element.getKey())) continue;
                    newElement.setRemove(element.getRemove());
                    this.holder.getTablesDialog().setBooleanValue("Remove", element.getRemove());
                    for (MaliciousAttachmentConfig el : element.getGenerateAttachmentList()) {
                        newEl = newElement.addNewGenerateAttachment();
                        newEl.setFilename(el.getFilename());
                        newEl.setSize(el.getSize());
                        newEl.setContentType(el.getContentType());
                        newEl.setEnabled(el.getEnabled());
                        newEl.setCached(el.getCached());
                        this.holder.addResultToGenerateTable(newEl);
                    }
                    for (MaliciousAttachmentConfig el : element.getReplaceAttachmentList()) {
                        newEl = newElement.addNewReplaceAttachment();
                        newEl.setFilename(el.getFilename());
                        newEl.setSize(el.getSize());
                        newEl.setContentType(el.getContentType());
                        newEl.setEnabled(el.getEnabled());
                        newEl.setCached(el.getCached());
                        this.holder.addResultToReplaceTable(newEl);
                    }
                    this.holder.refresh(attEl, null);
                    continue block0;
                }
            }
        }
    }

    public void updateConfig(MaliciousAttachmentSecurityScanConfig config) {
        this.config = config;
    }

    public void release() {
        this.list = null;
        this.config = null;
    }
}

