/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.MaliciousAttachmentConfig;
import com.eviware.soapui.config.MaliciousAttachmentElementConfig;
import com.eviware.soapui.config.MaliciousAttachmentSecurityScanConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.security.support.MaliciousAttachmentFilesListForm;
import com.eviware.soapui.security.support.MaliciousAttachmentGenerateTableModel;
import com.eviware.soapui.security.support.MaliciousAttachmentListToTableHolder;
import com.eviware.soapui.security.support.MaliciousAttachmentReplaceTableModel;
import com.eviware.soapui.security.support.MaliciousAttachmentTableModel;
import com.eviware.soapui.security.tools.AttachmentElement;
import com.eviware.soapui.security.ui.XPathCellRender;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.HelpActionMarker;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.swing.JTableFactory;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JCheckBoxFormField;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JTextFieldFormField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXTable;

public class MaliciousAttachmentMutationsPanel {
    private JFormDialog dialog;
    private MaliciousAttachmentSecurityScanConfig config;
    private JButton addGeneratedButton;
    private JButton removeGeneratedButton;
    private JButton addReplacementButton;
    private JButton removeReplacementButton;
    private AbstractHttpRequest<?> request;
    private MaliciousAttachmentListToTableHolder holder = new MaliciousAttachmentListToTableHolder();
    private JFormDialog tablesDialog;

    public MaliciousAttachmentMutationsPanel(MaliciousAttachmentSecurityScanConfig config, AbstractHttpRequest<?> request) {
        this.config = config;
        this.request = request;
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(MutationSettings.class);
        this.dialog.getFormField("###Mutations panel").setProperty("component", this.createMutationsPanel());
        this.dialog.getFormField("###Mutations panel").setProperty("dimension", new Dimension(720, 320));
    }

    private JComponent buildFilesList() {
        MaliciousAttachmentFilesListForm filesList = new MaliciousAttachmentFilesListForm(this.config, this.holder);
        this.holder.setFilesList(filesList);
        JScrollPane scrollPane = new JScrollPane(filesList);
        return scrollPane;
    }

    private JComponent buildTables() {
        this.tablesDialog = (JFormDialog)ADialogBuilder.buildDialog(MutationTables.class);
        MaliciousAttachmentGenerateTableModel generateTableModel = new MaliciousAttachmentGenerateTableModel();
        this.tablesDialog.getFormField("Generate").setProperty("dimension", new Dimension(410, 120));
        this.tablesDialog.getFormField("Generate").setProperty("component", this.buildGenerateTable(generateTableModel));
        MaliciousAttachmentReplaceTableModel replaceTableModel = new MaliciousAttachmentReplaceTableModel();
        this.tablesDialog.getFormField("Replace").setProperty("dimension", new Dimension(410, 120));
        this.tablesDialog.getFormField("Replace").setProperty("component", this.buildReplacementTable(replaceTableModel));
        this.holder.setGenerateTableModel(generateTableModel);
        this.holder.setReplaceTableModel(replaceTableModel);
        this.holder.setTablesDialog(this.tablesDialog);
        JCheckBoxFormField remove = (JCheckBoxFormField)this.tablesDialog.getFormField("Remove");
        remove.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                int idx = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getSelectedIndex();
                if (idx != -1) {
                    ListModel listModel = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getModel();
                    String key = ((AttachmentElement)listModel.getElementAt(idx)).getId();
                    for (MaliciousAttachmentElementConfig element : MaliciousAttachmentMutationsPanel.this.config.getElementList()) {
                        if (!key.equals(element.getKey())) continue;
                        element.setRemove(Boolean.parseBoolean(newValue));
                        break;
                    }
                }
            }
        });
        return this.tablesDialog.getPanel();
    }

    protected JPanel buildGenerateTable(MaliciousAttachmentTableModel tableModel) {
        JPanel panel = new JPanel(new BorderLayout());
        final JXTable table = JTableFactory.getInstance().makeJXTable(tableModel);
        this.setupTable(table);
        JScrollPane tableScrollPane = new JScrollPane((Component)table);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JXToolBar toolbar = UISupport.createToolbar();
        this.addGeneratedButton = UISupport.createToolbarButton(new GenerateFileAction());
        toolbar.add(this.addGeneratedButton);
        this.removeGeneratedButton = UISupport.createToolbarButton(new RemoveGeneratedFileAction(tableModel, table));
        toolbar.add(this.removeGeneratedButton);
        this.removeGeneratedButton.setEnabled(false);
        toolbar.add(UISupport.createToolbarButton(new HelpAction("/Security/malicious-attachment.html")));
        panel.add((Component)toolbar, "First");
        panel.add((Component)tableScrollPane, "Center");
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaliciousAttachmentMutationsPanel.this.removeGeneratedButton != null) {
                    MaliciousAttachmentMutationsPanel.this.removeGeneratedButton.setEnabled(table.getSelectedRowCount() > 0);
                }
            }
        });
        panel.setBorder(BorderFactory.createLineBorder(new Color(0), 1));
        return panel;
    }

    protected JPanel buildReplacementTable(MaliciousAttachmentTableModel tableModel) {
        JPanel panel = new JPanel(new BorderLayout());
        final JXTable table = JTableFactory.getInstance().makeJXTable(tableModel);
        this.setupTable(table);
        JScrollPane tableScrollPane = new JScrollPane((Component)table);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JXToolBar toolbar = UISupport.createToolbar();
        this.addReplacementButton = UISupport.createToolbarButton(new AddFileAction());
        toolbar.add(this.addReplacementButton);
        this.removeReplacementButton = UISupport.createToolbarButton(new RemoveReplacementFileAction(tableModel, table));
        toolbar.add(this.removeReplacementButton);
        this.removeReplacementButton.setEnabled(false);
        toolbar.add(UISupport.createToolbarButton(new HelpAction("/Security/malicious-attachment.html")));
        panel.add((Component)toolbar, "First");
        panel.add((Component)tableScrollPane, "Center");
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaliciousAttachmentMutationsPanel.this.removeReplacementButton != null) {
                    MaliciousAttachmentMutationsPanel.this.removeReplacementButton.setEnabled(table.getSelectedRowCount() > 0);
                }
            }
        });
        panel.setBorder(BorderFactory.createLineBorder(new Color(0), 1));
        return panel;
    }

    protected void setupTable(JXTable table) {
        table.setPreferredScrollableViewportSize(new Dimension(50, 90));
        table.setSelectionMode(0);
        table.getTableHeader().setReorderingAllowed(false);
        table.setDefaultEditor(String.class, this.getDefaultCellEditor());
        table.setSortable(false);
    }

    private Object createMutationsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JSplitPane mainSplit = UISupport.createHorizontalSplit(this.buildFilesList(), this.buildTables());
        mainSplit.setResizeWeight(1.0);
        panel.add((Component)mainSplit, "Center");
        return panel;
    }

    public JComponent getPanel() {
        MaliciousAttachmentFilesListForm filesList = this.holder.getFilesList();
        Attachment[] data = new Attachment[this.request.getAttachments().length];
        for (int i = 0; i < this.request.getAttachments().length; ++i) {
            data[i] = this.request.getAttachmentAt(i);
        }
        filesList.setData(data);
        this.holder.refresh();
        return this.dialog.getPanel();
    }

    protected TableCellEditor getDefaultCellEditor() {
        return new XPathCellRender();
    }

    public MaliciousAttachmentSecurityScanConfig getConfig() {
        return this.config;
    }

    public void setConfig(MaliciousAttachmentSecurityScanConfig config) {
        this.config = config;
    }

    public void updateConfig(MaliciousAttachmentSecurityScanConfig config) {
        this.setConfig(config);
        MaliciousAttachmentFilesListForm filesList = this.holder.getFilesList();
        if (filesList != null) {
            filesList.updateConfig(config);
        }
    }

    public MaliciousAttachmentListToTableHolder getHolder() {
        return this.holder;
    }

    public void release() {
        this.tablesDialog.release();
        this.dialog.release();
        this.config = null;
        this.dialog = null;
        this.request = null;
        this.holder.release();
        this.holder = null;
    }

    public class HelpAction
    extends AbstractAction
    implements HelpActionMarker {
        private final String url;

        public HelpAction(String url) {
            this("Online Help", url, UISupport.getKeyStroke("F1"));
        }

        public HelpAction(String title, String url) {
            this(title, url, null);
        }

        public HelpAction(String title, String url, KeyStroke accelerator) {
            super(title);
            this.url = url;
            this.putValue("ShortDescription", "Show online help");
            if (accelerator != null) {
                this.putValue("AcceleratorKey", accelerator);
            }
            this.putValue("SmallIcon", UISupport.HELP_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tools.openURL(this.url);
        }
    }

    public class RemoveGeneratedFileAction
    extends AbstractAction {
        private final MaliciousAttachmentTableModel tableModel;
        private final JXTable table;

        public RemoveGeneratedFileAction(MaliciousAttachmentTableModel tableModel, JXTable table) {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Remove file");
            this.tableModel = tableModel;
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.getSelectedRow();
            if (row >= 0) {
                this.tableModel.removeResult(row);
                int idx = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getSelectedIndex();
                if (idx != -1) {
                    ListModel listModel = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getModel();
                    String key = ((AttachmentElement)listModel.getElementAt(idx)).getId();
                    for (int i = 0; i < MaliciousAttachmentMutationsPanel.this.config.getElementList().size(); ++i) {
                        MaliciousAttachmentElementConfig element = MaliciousAttachmentMutationsPanel.this.config.getElementList().get(i);
                        if (!key.equals(element.getKey())) continue;
                        element.getGenerateAttachmentList().remove(row);
                    }
                }
            }
        }
    }

    public class RemoveReplacementFileAction
    extends AbstractAction {
        private final MaliciousAttachmentTableModel tableModel;
        private final JXTable table;

        public RemoveReplacementFileAction(MaliciousAttachmentTableModel tableModel, JXTable table) {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Remove file");
            this.tableModel = tableModel;
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.getSelectedRow();
            if (row >= 0) {
                this.tableModel.removeResult(row);
                int idx = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getSelectedIndex();
                if (idx != -1) {
                    ListModel listModel = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getModel();
                    String key = ((AttachmentElement)listModel.getElementAt(idx)).getId();
                    for (int i = 0; i < MaliciousAttachmentMutationsPanel.this.config.getElementList().size(); ++i) {
                        MaliciousAttachmentElementConfig element = MaliciousAttachmentMutationsPanel.this.config.getElementList().get(i);
                        if (!key.equals(element.getKey())) continue;
                        element.getReplaceAttachmentList().remove(row);
                    }
                }
            }
        }
    }

    public class GenerateFileAction
    extends AbstractAction {
        private XFormDialog dialog;

        public GenerateFileAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Generate file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(GenerateFile.class);
                ((JTextFieldFormField)this.dialog.getFormField("Content type")).setWidth(30);
            }
            this.dialog.show();
            if (this.dialog.getReturnValue() == 1) {
                Long newSize = 0L;
                String newSizeString = this.dialog.getValue("Size (bytes)");
                String contentType = this.dialog.getFormField("Content type").getValue();
                try {
                    newSize = Long.parseLong(newSizeString);
                }
                catch (NumberFormatException nfe) {
                    UISupport.showErrorMessage("Size must be numeric value");
                    return;
                }
                try {
                    File file = File.createTempFile(StringUtils.createFileName("attachment", '-'), "." + ContentTypeHandler.getExtensionForContentType(contentType));
                    String filename = file.getAbsolutePath();
                    Boolean enabled = new Boolean(true);
                    Boolean cached = new Boolean(true);
                    boolean added = false;
                    int idx = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getSelectedIndex();
                    if (idx != -1) {
                        ListModel listModel = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getModel();
                        String key = ((AttachmentElement)listModel.getElementAt(idx)).getId();
                        for (MaliciousAttachmentElementConfig element : MaliciousAttachmentMutationsPanel.this.config.getElementList()) {
                            if (!key.equals(element.getKey())) continue;
                            MaliciousAttachmentConfig att = element.addNewGenerateAttachment();
                            att.setFilename(filename);
                            att.setSize(newSize);
                            att.setContentType(contentType);
                            att.setEnabled(enabled);
                            att.setCached(cached);
                            MaliciousAttachmentMutationsPanel.this.holder.addResultToGenerateTable(att);
                            added = true;
                        }
                    }
                    if (!added) {
                        UISupport.showErrorMessage("No attachments found in test step");
                    }
                }
                catch (Exception e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    public class AddFileAction
    extends AbstractAction {
        private JFileChooser fileChooser;

        public AddFileAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Add file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            String root;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
            }
            if (StringUtils.hasContent(root = ProjectSettings.PROJECT_ROOT)) {
                this.fileChooser.setCurrentDirectory(new File(root));
            }
            if ((returnVal = this.fileChooser.showOpenDialog(UISupport.getMainFrame())) == 0) {
                File file = this.fileChooser.getSelectedFile();
                Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Add Attachment");
                if (retval == null) {
                    return;
                }
                String filename = file.getAbsolutePath();
                Long size = file.length();
                String contentType = new MimetypesFileTypeMap().getContentType(file);
                Boolean enabled = new Boolean(true);
                Boolean cached = retval;
                boolean added = false;
                int idx = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getSelectedIndex();
                if (idx != -1) {
                    ListModel listModel = MaliciousAttachmentMutationsPanel.this.holder.getFilesList().getList().getModel();
                    String key = ((AttachmentElement)listModel.getElementAt(idx)).getId();
                    for (MaliciousAttachmentElementConfig element : MaliciousAttachmentMutationsPanel.this.config.getElementList()) {
                        if (!key.equals(element.getKey())) continue;
                        MaliciousAttachmentConfig att = element.addNewReplaceAttachment();
                        att.setFilename(filename);
                        att.setSize(size);
                        att.setContentType(contentType);
                        att.setEnabled(enabled);
                        att.setCached(cached);
                        MaliciousAttachmentMutationsPanel.this.holder.addResultToReplaceTable(att);
                        added = true;
                    }
                }
                if (!added) {
                    UISupport.showErrorMessage("No attachments found in test step");
                }
            }
        }
    }

    @AForm(description="Generate File Mutation", name="Generate File Mutation")
    public static interface GenerateFile {
        @AField(description="Size (bytes)", name="Size (bytes)", type=AField.AFieldType.INT)
        public static final String SIZE = "Size (bytes)";
        @AField(description="Content type", name="Content type", type=AField.AFieldType.STRING)
        public static final String CONTENT_TYPE = "Content type";
    }

    @AForm(description="Malicious Attachment Mutation Tables", name="Malicious Attachment Mutation Tables")
    public static interface MutationTables {
        @AField(description="<html><b>Specify below how selected attachment should be mutated</b></html>", name="###Label", type=AField.AFieldType.LABEL)
        public static final String LABEL = "###Label";
        @AField(description="Generate file", name="Generate", type=AField.AFieldType.COMPONENT)
        public static final String GENERATE_FILE = "Generate";
        @AField(description="Replace file", name="Replace", type=AField.AFieldType.COMPONENT)
        public static final String REPLACE_FILE = "Replace";
        @AField(description="Do not send the attachment with the request", name="Remove", type=AField.AFieldType.BOOLEAN)
        public static final String REMOVE_FILE = "Remove";
    }

    @AForm(description="Malicious Attachment Mutations", name="Malicious Attachment Mutations")
    public static interface MutationSettings {
        @AField(description="###Mutations panel", name="###Mutations panel", type=AField.AFieldType.COMPONENT)
        public static final String MUTATIONS_PANEL = "###Mutations panel";
    }
}

