/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.MutableValue;
import com.eviware.soapui.support.PlainJavaJsonProvider;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.internal.PathTokenizer;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;

public class JsonPathFacade {
    private String currentJson;
    private Object jsonObject;

    public JsonPathFacade(String targetJson) {
        if (!JsonUtil.isValidJson(targetJson)) {
            throw new IllegalArgumentException("Invalid JSON: " + targetJson);
        }
        this.currentJson = targetJson;
        this.jsonObject = new JsonSlurper().parseText(targetJson);
    }

    public String readStringValue(String jsonPathExpression) {
        return String.valueOf(this.readObjectValue(jsonPathExpression));
    }

    public void writeValue(String jsonPathExpression, Object value) {
        PlainJavaJsonProvider provider = new PlainJavaJsonProvider();
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)provider).build();
        this.jsonObject = provider.parse(this.currentJson);
        JsonPath path = JsonPath.compile((String)jsonPathExpression, (Filter[])new Filter[0]);
        LinkedList<PathToken> pathTokens = this.getPathTokensFrom(path);
        PathToken endToken = pathTokens.removeLast();
        int index = pathTokens.size();
        JsonWriteDecorator writeDecorator = new JsonWriteDecorator(provider, index, endToken, value);
        pathTokens.addLast(writeDecorator);
        path.read(this.jsonObject, configuration);
        this.jsonObject = MutableValue.FROM_MUTABLE_VALUE.apply(this.jsonObject);
        this.currentJson = this.buildJsonStringFrom(this.jsonObject);
    }

    private String buildJsonStringFrom(Object sourceObject) {
        Object json = this.makeJSONObject(sourceObject);
        return json instanceof JSON ? ((JSON)json).toString(3) : json.toString();
    }

    private Object makeJSONObject(Object sourceObject) {
        if (sourceObject instanceof Map) {
            JSONObject jsonObject = new JSONObject();
            Map sourceMap = (Map)sourceObject;
            for (Object key : sourceMap.keySet()) {
                jsonObject.put(key, this.makeJSONObject(sourceMap.get(key)));
            }
            return jsonObject;
        }
        if (sourceObject instanceof List) {
            List sourceList = (List)sourceObject;
            JSONArray array = new JSONArray();
            for (Object element : sourceList) {
                array.add(this.makeJSONObject(element));
            }
            return array;
        }
        return sourceObject;
    }

    private void removeMutableWrappersFrom(JSON jsonObject) {
        block3: {
            block2: {
                if (!jsonObject.isArray()) break block2;
                JSONArray array = (JSONArray)jsonObject;
                for (int i = 0; i < array.size(); ++i) {
                    array.set(i, this.removeMutableWrapperFrom(array.get(i)));
                }
                break block3;
            }
            if (!(jsonObject instanceof JSONObject)) break block3;
            JSONObject object = (JSONObject)jsonObject;
            for (Object key : object.keySet()) {
                object.put(key, this.removeMutableWrapperFrom(object.get(key)));
            }
        }
    }

    private Object removeMutableWrapperFrom(Object o) {
        Object value = MutableValue.extractValueFromMutable(o);
        if (value instanceof JSON) {
            this.removeMutableWrappersFrom((JSON)value);
        }
        return value;
    }

    private LinkedList<PathToken> getPathTokensFrom(JsonPath jsonPathObject) {
        try {
            Field tokenizerField = JsonPath.class.getDeclaredField("tokenizer");
            tokenizerField.setAccessible(true);
            PathTokenizer tokenizer = (PathTokenizer)tokenizerField.get(jsonPathObject);
            Field pathTokensField = PathTokenizer.class.getDeclaredField("pathTokens");
            pathTokensField.setAccessible(true);
            return (LinkedList)pathTokensField.get(tokenizer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getJSON() {
        return this.jsonObject;
    }

    public String getCurrentJson() {
        return this.currentJson;
    }

    public <T> T readObjectValue(String jsonPathExpression) {
        PlainJavaJsonProvider provider = new PlainJavaJsonProvider();
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)provider).build();
        JsonPath jsonPath = JsonPath.compile((String)jsonPathExpression, (Filter[])new Filter[0]);
        return (T)jsonPath.read(this.jsonObject, configuration);
    }

    private class JsonWriteDecorator
    extends PathToken {
        private final PlainJavaJsonProvider provider;
        private final Object value;

        public JsonWriteDecorator(PlainJavaJsonProvider provider, int index, PathToken endToken, Object value) {
            super(endToken.getFragment(), index, true);
            this.provider = provider;
            this.value = value;
        }

        public PathTokenFilter getFilter() {
            this.provider.setValueToWrite(this.value);
            return super.getFilter();
        }
    }
}

