/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.editor.registry.InspectorFactory;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import java.util.ArrayList;
import java.util.List;

public class InspectorRegistry
implements SoapUIFactoryRegistryListener {
    private static InspectorRegistry instance;
    private List<InspectorFactory> factories = new ArrayList<InspectorFactory>();

    private InspectorRegistry() {
        for (InspectorFactory factory : SoapUI.getFactoryRegistry().getFactories(InspectorFactory.class)) {
            this.addFactory(factory);
        }
        SoapUI.getFactoryRegistry().addFactoryRegistryListener(this);
    }

    public void addFactory(InspectorFactory factory) {
        for (int c = 0; c < this.factories.size(); ++c) {
            InspectorFactory f = this.factories.get(c);
            if (!f.getInspectorId().equals(factory.getInspectorId())) continue;
            this.factories.set(c, factory);
            return;
        }
        this.factories.add(factory);
    }

    public static final InspectorRegistry getInstance() {
        if (instance == null) {
            instance = new InspectorRegistry();
        }
        return instance;
    }

    public void removeFactory(InspectorFactory factory) {
        this.factories.remove(factory);
    }

    public InspectorFactory[] getFactories() {
        return this.factories.toArray(new InspectorFactory[this.factories.size()]);
    }

    public InspectorFactory[] getFactoriesOfType(Class<?> type) {
        ArrayList<InspectorFactory> result = new ArrayList<InspectorFactory>();
        for (InspectorFactory factory : this.factories) {
            if (!type.isAssignableFrom(factory.getClass())) continue;
            result.add(factory);
        }
        return result.toArray(new InspectorFactory[result.size()]);
    }

    @Override
    public void factoryAdded(Class<?> factoryType, Object factory) {
        if (factoryType.isAssignableFrom(InspectorFactory.class)) {
            this.addFactory((InspectorFactory)factory);
        }
    }

    @Override
    public void factoryRemoved(Class<?> factoryType, Object factory) {
        if (factoryType.isAssignableFrom(InspectorFactory.class)) {
            this.removeFactory((InspectorFactory)factory);
        }
    }
}

