/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.action.support.DefaultActionMapping;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MenuBuilderHelper {
    public static JMenu getMenu(String name) {
        JMenuBar menuBar = SoapUI.getMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            if (!menuBar.getMenu(i).getText().equals(name)) continue;
            return menuBar.getMenu(i);
        }
        return null;
    }

    public static JMenu buildMenuForWorkspace(JMenu menu, String actionGroup) {
        ActionList actions = MenuBuilderHelper.buildActionsForActionGroup(actionGroup);
        if (menu.getText().equals("Step")) {
            DefaultActionMapping toggleDisabledActionMapping = null;
            DefaultActionMapping actionMapping = new DefaultActionMapping("ShowDesktopPanelAction", "ENTER", null, true, null);
            actionMapping.setName("Open Editor");
            actionMapping.setDescription("Opens the editor for this TestStep");
            SwingActionDelegate<Object> actionDelegate = new SwingActionDelegate<Object>(actionMapping, null);
            menu.add(actionDelegate);
            toggleDisabledActionMapping = new DefaultActionMapping("ToggleDisableTestStepAction", null, null, false, null);
            SwingActionDelegate<Object> actionDelegateToggle = new SwingActionDelegate<Object>(toggleDisabledActionMapping, null);
            menu.add(actionDelegateToggle);
        }
        ActionSupport.addActions(actions, menu);
        for (Component component : menu.getMenuComponents()) {
            MenuBuilderHelper.activateMenuSubItems(component, false);
            component.setEnabled(false);
        }
        return menu;
    }

    protected static ActionList buildActionsForActionGroup(String actionGroup) {
        return ActionListBuilder.buildActions(actionGroup, null);
    }

    private static void activateMenuItems(String groupId, boolean activate) {
        JMenu menu = MenuBuilderHelper.getMenu(groupId);
        for (Component component : menu.getMenuComponents()) {
            MenuBuilderHelper.activateMenuSubItems(component, activate);
            component.setEnabled(activate);
        }
    }

    private static void activateMenuSubItems(Component component, boolean bEnable) {
        if (component instanceof JMenu) {
            for (Component curComponent : ((JMenu)component).getMenuComponents()) {
                curComponent.setEnabled(bEnable);
            }
        }
    }

    private static void buildMenu(ModelItem curModelItem, String menuName, SoapUITreeNode path) {
        String[] groupsId = new String[]{"Step", "Case", "Suite", "Project"};
        if (curModelItem instanceof Workspace) {
            for (String groupId : groupsId) {
                MenuBuilderHelper.activateMenuItems(groupId, false);
            }
        } else if (ModelSupport.isOneOf(curModelItem, WsdlTestSuite.class, WsdlTestCase.class, WsdlTestStep.class, WsdlProject.class)) {
            ActionList actionList = ActionListBuilder.buildActions(curModelItem);
            JMenu curMenu = MenuBuilderHelper.getMenu(menuName);
            curMenu.removeAll();
            ActionSupport.addActions(actionList, curMenu);
            for (String groupId : groupsId) {
                if (groupId.equals(menuName)) break;
                MenuBuilderHelper.activateMenuItems(groupId, false);
            }
            while (!(curModelItem.getParent() instanceof Workspace)) {
                curModelItem = curModelItem.getParent();
                ActionList parentActionList = ActionListBuilder.buildActions(curModelItem);
                JMenu parentMenu = MenuBuilderHelper.getMenu(MenuBuilderHelper.getMenuNameForModelItem(curModelItem));
                parentMenu.removeAll();
                ActionSupport.addActions(parentActionList, parentMenu);
                MenuBuilderHelper.activateMenuItems(MenuBuilderHelper.getMenuNameForModelItem(curModelItem), true);
            }
        } else {
            SoapUITreeNode node = path.getParentTreeNode();
            curModelItem = node.getModelItem();
            while (!(curModelItem instanceof Workspace)) {
                if (curModelItem instanceof WsdlTestCase) {
                    MenuBuilderHelper.buildMenu(curModelItem, "Case", null);
                    break;
                }
                if (curModelItem instanceof WsdlProject) {
                    MenuBuilderHelper.buildMenu(curModelItem, "Project", null);
                    break;
                }
                node = node.getParentTreeNode();
                curModelItem = node.getModelItem();
            }
        }
    }

    public static void buildTreeNodeMenu(SoapUITreeNode treeNode) {
        ModelItem modelItem = treeNode.getModelItem();
        MenuBuilderHelper.buildMenu(modelItem, MenuBuilderHelper.getMenuNameForModelItem(modelItem), treeNode);
    }

    private static String getMenuNameForModelItem(ModelItem modelItem) {
        if (modelItem instanceof WsdlTestSuite) {
            return "Suite";
        }
        if (modelItem instanceof WsdlTestStep) {
            return "Step";
        }
        if (modelItem instanceof WsdlProject) {
            return "Project";
        }
        return "Case";
    }
}

