/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.MockServiceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.ui.desktop.DesktopListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;

public abstract class AbstractSoapUIDesktop
implements SoapUIDesktop {
    private final Workspace workspace;
    private final InternalProjectListener projectListener = new InternalProjectListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private final InternalMockServiceListener mockServiceListener = new InternalMockServiceListener();
    private Set<DesktopListener> listeners = new HashSet<DesktopListener>();
    private InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();

    public AbstractSoapUIDesktop(Workspace workspace) {
        this.workspace = workspace;
        this.initListeners();
    }

    private void initListeners() {
        this.workspace.addWorkspaceListener(this.workspaceListener);
        for (int c = 0; c < this.workspace.getProjectCount(); ++c) {
            this.listenToProject(this.workspace.getProjectAt(c));
        }
    }

    @Override
    public ActionList getActions() {
        return null;
    }

    private void listenToProject(Project project) {
        int i;
        project.addProjectListener(this.projectListener);
        for (i = 0; i < project.getInterfaceCount(); ++i) {
            project.getInterfaceAt(i).addInterfaceListener(this.interfaceListener);
        }
        for (i = 0; i < project.getTestSuiteCount(); ++i) {
            project.getTestSuiteAt(i).addTestSuiteListener(this.testSuiteListener);
        }
        for (i = 0; i < project.getMockServiceCount(); ++i) {
            project.getMockServiceAt(i).addMockServiceListener(this.mockServiceListener);
        }
    }

    @Override
    public void addDesktopListener(DesktopListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDesktopListener(DesktopListener listener) {
        this.listeners.remove(listener);
    }

    public void closeDependantPanels(ModelItem modelItem) {
        DesktopPanel[] panels = this.getDesktopPanels();
        for (int c = 0; c < panels.length; ++c) {
            if (!panels[c].dependsOn(modelItem)) continue;
            this.closeDesktopPanel(panels[c]);
        }
    }

    protected void fireDesktopPanelCreated(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelCreated(desktopPanel);
            }
        }
    }

    protected void fireDesktopPanelSelected(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelSelected(desktopPanel);
            }
        }
    }

    protected void fireDesktopPanelClosed(DesktopPanel desktopPanel) {
        if (!this.listeners.isEmpty()) {
            DesktopListener[] array;
            for (DesktopListener listener : array = this.listeners.toArray(new DesktopListener[this.listeners.size()])) {
                listener.desktopPanelClosed(desktopPanel);
            }
        }
    }

    @Override
    public void release() {
        for (int c = 0; c < this.workspace.getProjectCount(); ++c) {
            int i;
            Project project = this.workspace.getProjectAt(c);
            project.removeProjectListener(this.projectListener);
            for (i = 0; i < project.getInterfaceCount(); ++i) {
                project.getInterfaceAt(i).removeInterfaceListener(this.interfaceListener);
            }
            for (i = 0; i < project.getTestSuiteCount(); ++i) {
                project.getTestSuiteAt(i).removeTestSuiteListener(this.testSuiteListener);
            }
            for (i = 0; i < project.getMockServiceCount(); ++i) {
                project.getMockServiceAt(i).removeMockServiceListener(this.mockServiceListener);
            }
        }
        this.workspace.removeWorkspaceListener(this.workspaceListener);
    }

    @Override
    public void init() {
    }

    @Override
    public void showInspector(JComponent component) {
    }

    private class InternalMockServiceListener
    extends MockServiceListenerAdapter {
        private InternalMockServiceListener() {
        }

        @Override
        public void mockOperationRemoved(MockOperation operation) {
            AbstractSoapUIDesktop.this.closeDependantPanels(operation);
        }

        @Override
        public void mockResponseRemoved(MockResponse request) {
            AbstractSoapUIDesktop.this.closeDependantPanels(request);
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            AbstractSoapUIDesktop.this.closeDependantPanels(testCase);
        }

        @Override
        public void testStepRemoved(TestStep testStep, int index) {
            AbstractSoapUIDesktop.this.closeDependantPanels(testStep);
        }

        @Override
        public void loadTestRemoved(LoadTest loadTest) {
            AbstractSoapUIDesktop.this.closeDependantPanels(loadTest);
        }

        @Override
        public void securityTestRemoved(SecurityTest securityTest) {
            AbstractSoapUIDesktop.this.closeDependantPanels(securityTest);
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        @Override
        public void operationRemoved(Operation operation) {
            AbstractSoapUIDesktop.this.closeDependantPanels(operation);
        }

        @Override
        public void requestRemoved(Request request) {
            AbstractSoapUIDesktop.this.closeDependantPanels(request);
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void interfaceRemoved(Interface iface) {
            iface.removeInterfaceListener(AbstractSoapUIDesktop.this.interfaceListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(iface);
        }

        @Override
        public void testSuiteRemoved(TestSuite testSuite) {
            testSuite.removeTestSuiteListener(AbstractSoapUIDesktop.this.testSuiteListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(testSuite);
        }

        @Override
        public void interfaceAdded(Interface iface) {
            iface.addInterfaceListener(AbstractSoapUIDesktop.this.interfaceListener);
        }

        @Override
        public void testSuiteAdded(TestSuite testSuite) {
            testSuite.addTestSuiteListener(AbstractSoapUIDesktop.this.testSuiteListener);
        }

        @Override
        public void mockServiceAdded(MockService mockService) {
            mockService.addMockServiceListener(AbstractSoapUIDesktop.this.mockServiceListener);
        }

        @Override
        public void mockServiceRemoved(MockService mockService) {
            mockService.removeMockServiceListener(AbstractSoapUIDesktop.this.mockServiceListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(mockService);
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceListenerAdapter {
        private InternalWorkspaceListener() {
        }

        @Override
        public void projectRemoved(Project project) {
            project.removeProjectListener(AbstractSoapUIDesktop.this.projectListener);
            AbstractSoapUIDesktop.this.closeDependantPanels(project);
        }

        @Override
        public void projectAdded(Project project) {
            AbstractSoapUIDesktop.this.listenToProject(project);
        }
    }
}

