/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.ArtifactResult;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.TestAssertionsDocument;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.entrytypes.SecureEntryType;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureEnvelopeArtifact
extends Artifact {
    public SecureEnvelopeArtifact(Element element, ProfileService profileService) throws ValidatorException {
        super(element, profileService);
    }

    private List<Class<? extends SecureEntryType>> getEntryTypeClasses(TestAssertionsDocument testAssertionsDocument) throws ValidatorException {
        ArrayList<Class<? extends SecureEntryType>> arrayList = new ArrayList<Class<? extends SecureEntryType>>();
        for (String string : (List)testAssertionsDocument.getAllEntryTypeTags().get("secureEnvelope")) {
            if (string.equals("anySecureEnvelope")) {
                string = "secureEnvelope";
            }
            String string2 = string.substring(0, 1).toUpperCase() + string.substring(1) + "EntryType";
            Class<SecureEntryType> clazz = null;
            try {
                clazz = Class.forName("org.wsi.test.validator.bsp10.entrytypes." + string2).asSubclass(SecureEntryType.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ValidatorException((Exception)classNotFoundException);
            }
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public ArtifactResult validate(Configuration configuration) throws ValidatorException {
        ArtifactResult artifactResult = new ArtifactResult(this.getType());
        List list = configuration.getLogFile().getMessageEntryElements();
        for (Class<? extends SecureEntryType> clazz : this.getEntryTypeClasses(configuration.getTad())) {
            SecureEntryType.Factory factory = null;
            try {
                factory = (SecureEntryType.Factory)clazz.getMethod("getFactory", null).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                throw new ValidatorException(exception);
            }
            for (Element element : list) {
                Document document;
                SecureEntryType[] secureEntryTypeArray;
                String string = element.getAttribute("ID");
                NodeList nodeList = element.getChildNodes();
                Node node = null;
                for (int i = 0; !(i >= nodeList.getLength() || nodeList.item(i).getNodeType() == 1 && (node = (Element)nodeList.item(i)).getLocalName().equals("messageContent")); ++i) {
                }
                if (node == null || !node.getLocalName().equals("messageContent")) {
                    throw new ValidatorException("XML log file is invalid");
                }
                NodeList nodeList2 = node.getChildNodes();
                if (nodeList2.getLength() == 0) continue;
                if (nodeList2.getLength() > 1) {
                    throw new ValidatorException("XML file is invalid");
                }
                CharacterData characterData = (CharacterData)nodeList2.item(0);
                String string2 = characterData.getData();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                try {
                    secureEntryTypeArray = documentBuilderFactory.newDocumentBuilder();
                    document = secureEntryTypeArray.parse(byteArrayInputStream);
                }
                catch (Exception exception) {
                    throw new ValidatorException(exception);
                }
                secureEntryTypeArray = factory.collectFromSoapEnvelope(document.getDocumentElement());
                for (int i = 0; i < secureEntryTypeArray.length; ++i) {
                    artifactResult.addEntryResult(secureEntryTypeArray[i].validate(this, string));
                }
            }
        }
        return artifactResult;
    }
}

