/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10.entrytypes;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.EntryResult;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.SecureConstants;
import org.wsi.test.validator.bsp10.SecureEntryResult;
import org.wsi.test.validator.bsp10.entrytypes.SoapEnvelopeEntryType;

public abstract class SecureEntryType
extends Entry {
    public SecureEntryType(Element element) {
        super(element);
    }

    public String getTextNodeContents() throws ValidatorException {
        NodeList nodeList = this.getElement().getChildNodes();
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            if (string == null) {
                string = ((Text)nodeList.item(i)).getData();
                continue;
            }
            throw new ValidatorException("Unexpectedly found more than one TEXT_NODE");
        }
        return string;
    }

    public Element getSoapEnvelope() {
        Element element = this.getElement();
        while (!SoapEnvelopeEntryType.getFactory().isValidElement(element)) {
            element = (Element)element.getParentNode();
        }
        return element;
    }

    protected String getWsuIdOrId() {
        String string = this.getWsuIdAttribute();
        if (string != null) {
            return string;
        }
        return this.getIdAttribute();
    }

    protected String getWsuIdAttribute() {
        if (this.getElement().hasAttributeNS(SecureConstants.WSU_NAMESPACE, "Id")) {
            return this.getElement().getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id");
        }
        return null;
    }

    protected String getIdAttribute() {
        if (this.getElement().hasAttribute("Id")) {
            return this.getElement().getAttribute("Id");
        }
        return null;
    }

    protected EntryResult getEntryResultInstance(Entry entry, String string) {
        return new SecureEntryResult(entry, string);
    }

    public static abstract class Factory {
        public abstract boolean isValidElement(Element var1);

        public abstract SecureEntryType newInstance(Element var1);

        public SecureEntryType[] collectFromSoapEnvelope(Element element) {
            ArrayList<SecureEntryType> arrayList = new ArrayList<SecureEntryType>();
            if (this.isValidElement(element)) {
                arrayList.add(this.newInstance(element));
            }
            NodeList nodeList = element.getElementsByTagName("*");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (!this.isValidElement(element2)) continue;
                arrayList.add(this.newInstance(element2));
            }
            return arrayList.toArray(new SecureEntryType[0]);
        }

        protected boolean checkURIandName(Element element, String string, String string2) {
            String string3 = element.getNamespaceURI();
            if (string3 == null) {
                return false;
            }
            if (!string3.equals(string)) {
                return false;
            }
            return element.getLocalName().equals(string2);
        }
    }
}

