/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.wsi.test.util.XMLInfo;

public class ToolEnvironment {
    public static final String ELEM_NAME = "environment";
    protected String runtimeName = System.getProperty("java.runtime.name");
    protected String runtimeVersion = System.getProperty("java.runtime.version");
    protected String osName = System.getProperty("os.name");
    protected String osVersion = System.getProperty("os.version");
    protected String xmlParserName = "?";
    protected String xmlParserVersion = "?";
    protected XMLInfo xmlInfo = null;

    public ToolEnvironment() {
        try {
            this.xmlParserVersion = "unknown";
            this.xmlParserName = "Apache Xerces";
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public ToolEnvironment(XMLInfo xMLInfo) {
        this.xmlInfo = xMLInfo;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getOSVersion() {
        return this.osVersion;
    }

    public String getXMLParserName() {
        return this.xmlParserName;
    }

    public String getXMLParserVersion() {
        return this.xmlParserVersion;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setOSName(String string) {
        this.osName = string;
    }

    public void setOSVersion(String string) {
        this.osVersion = string;
    }

    public void setXMLParserName(String string) {
        this.xmlParserName = string;
    }

    public void setXMLParserVersion(String string) {
        this.xmlParserVersion = string;
    }

    public void setRuntimeName(String string) {
        this.runtimeName = string;
    }

    public void setRuntimeVersion(String string) {
        this.runtimeVersion = string;
    }

    public void setAdditionalToolEnvironment(XMLInfo xMLInfo) {
        this.xmlInfo = xMLInfo;
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("")) {
            string2 = string2 + ":";
        }
        printWriter.println("    <" + string2 + ELEM_NAME + ">");
        printWriter.print("      <" + string2 + "runtime" + " ");
        printWriter.print("name=\"" + this.runtimeName + "\" ");
        printWriter.println("version=\"" + this.runtimeVersion + "\"/>");
        printWriter.print("      <" + string2 + "operatingSystem" + " ");
        printWriter.print("name=\"" + this.osName + "\" ");
        printWriter.println("version=\"" + this.osVersion + "\"/>");
        printWriter.print("      <" + string2 + "xmlParser" + " ");
        printWriter.print("name=\"" + this.xmlParserName + "\" ");
        printWriter.println("version=\"" + this.xmlParserVersion + "\"/>");
        if (this.xmlInfo != null) {
            printWriter.print(this.xmlInfo.toXMLString(string2));
        }
        printWriter.println("    </" + string2 + ELEM_NAME + ">");
        return stringWriter.toString();
    }
}

