/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.wsi.test.util.BasicRules;
import sun.net.www.MessageHeader;

public class HttpHeadersValidator {
    private static final String HEADER_ALLOW = "Allow";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_CONTENT_LANGUAGE = "Content-Language";
    private static final String HEADER_CONTENT_LENGHT = "Content-Length";
    private static final String HEADER_CONTENT_LOCATION = "Content-Location";
    private static final String HEADER_CONTENT_MD5 = "Content-MD5";
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_DATE = "Date";
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_TRAILER = "Trailer";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_UPGRADE = "Upgrade";
    private static final String HEADER_VIA = "Via";
    private static final String HEADER_WARNING = "Warning";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_EXPECT = "Expect";
    private static final String HEADER_FROM = "From";
    private static final String HEADER_HOST = "Host";
    private static final String HEADER_IF_MATCH = "If-Match";
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_IF_RANGE = "If-Range";
    private static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String HEADER_MAX_FORWARDS = "Max-Forwards";
    private static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String HEADER_RANGE = "Range";
    private static final String HEADER_REFERER = "Referer";
    private static final String HEADER_TE = "TE";
    private static final String HEADER_USER_AGENT = "User-Agent";

    public static boolean validateHttpRequestHeaders(String string) {
        MessageHeader messageHeader = new MessageHeader();
        try {
            messageHeader.parseHeader(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException iOException) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        string2 = messageHeader.getKey(0);
        if (string2 != null) {
            return false;
        }
        string3 = messageHeader.getValue(0);
        if (string3 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        if (!stringTokenizer.hasMoreElements()) {
            return false;
        }
        String string4 = stringTokenizer.nextToken();
        if (!HttpHeadersValidator.isToken(string4)) {
            return false;
        }
        if (!stringTokenizer.hasMoreElements()) {
            return false;
        }
        string4 = stringTokenizer.nextToken();
        if (!HttpHeadersValidator.isURI(string4) && !string4.equals("*")) {
            return false;
        }
        if (!stringTokenizer.hasMoreElements()) {
            return false;
        }
        string4 = stringTokenizer.nextToken();
        if (!HttpHeadersValidator.isHTTPVersion(string4)) {
            return false;
        }
        int n = 1;
        try {
            while ((string2 = messageHeader.getKey(n)) != null) {
                string3 = messageHeader.getValue(n);
                ++n;
                if (!HttpHeadersValidator.isToken(string2)) {
                    return false;
                }
                if (!(string2.equals(HEADER_ALLOW) ? !HttpHeadersValidator.isValidAllow(string3) : (string2.equals(HEADER_CONTENT_TYPE) ? !HttpHeadersValidator.isMediaType(string3) : (string2.equals(HEADER_CONTENT_ENCODING) ? !HttpHeadersValidator.isToken(string3) : (string2.equals(HEADER_CONTENT_LANGUAGE) ? !HttpHeadersValidator.isLanguageTag(string3) : (string2.equals(HEADER_CONTENT_LENGHT) ? !HttpHeadersValidator.isDidgit(string3) : (string2.equals(HEADER_CONTENT_LOCATION) ? !HttpHeadersValidator.isURI(string3) : (string2.equals(HEADER_CONTENT_RANGE) ? !HttpHeadersValidator.isValidContentRange(string3) : (string2.equals(HEADER_EXPIRES) || string2.equals(HEADER_LAST_MODIFIED) ? !HttpHeadersValidator.isHTTPDate(string3) : (string2.equals(HEADER_CACHE_CONTROL) ? !HttpHeadersValidator.isValidCacheControl(string3) : (string2.equals(HEADER_CONNECTION) ? !HttpHeadersValidator.isToken(string3) : (string2.equals(HEADER_DATE) ? !HttpHeadersValidator.isHTTPDate(string3) : (string2.equals(HEADER_PRAGMA) ? !HttpHeadersValidator.isPragmaDerective(string3) : (string2.equals(HEADER_TRAILER) ? !HttpHeadersValidator.isToken(string3) : (string2.equals(HEADER_TRANSFER_ENCODING) ? !HttpHeadersValidator.isTransferCoding(string3) : (string2.equals(HEADER_UPGRADE) ? !HttpHeadersValidator.isValidUpgrade(string3) : (string2.equals(HEADER_VIA) ? !HttpHeadersValidator.isValidVia(string3) : (string2.equals(HEADER_WARNING) ? !HttpHeadersValidator.isValidWarning(string3) : (string2.equals(HEADER_ACCEPT) ? !HttpHeadersValidator.isValidAccept(string3) : (string2.equals(HEADER_ACCEPT_CHARSET) ? !HttpHeadersValidator.isValidAcceptCharSet(string3) : (string2.equals(HEADER_ACCEPT_ENCODING) ? !HttpHeadersValidator.isValidAcceptEncoding(string3) : (string2.equals(HEADER_ACCEPT_LANGUAGE) ? !HttpHeadersValidator.isValidAcceptLanguage(string3) : (string2.equals(HEADER_AUTHORIZATION) || string2.equals(HEADER_PROXY_AUTHORIZATION) ? !HttpHeadersValidator.isCredentials(string3) : (string2.equals(HEADER_EXPECT) ? !HttpHeadersValidator.isExpectation(string3) : (string2.equals(HEADER_FROM) ? !MailboxValidator.validateMailbox(string3) : (string2.equals(HEADER_IF_MATCH) || string2.equals(HEADER_IF_NONE_MATCH) ? !HttpHeadersValidator.isValidIfMatch(string3) : (string2.equals(HEADER_IF_RANGE) ? !HttpHeadersValidator.isEntityTag(string3) && !HttpHeadersValidator.isHTTPDate(string3) : (string2.equals(HEADER_IF_MODIFIED_SINCE) ? !HttpHeadersValidator.isHTTPDate(string3) : (string2.equals(HEADER_IF_UNMODIFIED_SINCE) ? !HttpHeadersValidator.isHTTPDate(string3) : (string2.equals(HEADER_MAX_FORWARDS) ? !HttpHeadersValidator.isDidgit(string3) : (string2.equals(HEADER_USER_AGENT) ? !HttpHeadersValidator.isValidUserAgent(string3) : (string2.equals(HEADER_TE) ? !HttpHeadersValidator.isValidTE(string3) : (string2.equals(HEADER_RANGE) ? !HttpHeadersValidator.isRange(string3) : (string2.equals(HEADER_HOST) ? !HttpHeadersValidator.isHost(string3) : string2.equals(HEADER_REFERER) && !HttpHeadersValidator.isURI(string3))))))))))))))))))))))))))))))))))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isValidIfMatch(String string) {
        if (string.trim().length() == 0) {
            return true;
        }
        if ("*".equals(string.trim())) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (HttpHeadersValidator.isEntityTag(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidUpgrade(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (HttpHeadersValidator.isProduct(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCacheControl(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            if (!HttpHeadersValidator.isToken(string2.substring(0, n))) {
                return false;
            }
            String string3 = string2.substring(n + 1);
            if (HttpHeadersValidator.isToken(string3) || HttpHeadersValidator.isQuotedString(string3)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHTTPVersion(String string) {
        int n;
        if (!string.startsWith("HTTP/")) {
            return false;
        }
        int n2 = "HTTP/".length();
        String string2 = string.substring(n2, n = string.indexOf("."));
        if (!HttpHeadersValidator.isDidgit(string2)) {
            return false;
        }
        string2 = string.substring(n + 1);
        return HttpHeadersValidator.isDidgit(string2);
    }

    private static boolean isValidWarning(String string) {
        if (string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim(), " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.length() > 3 || !HttpHeadersValidator.isDidgit(string2)) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        if (!HttpHeadersValidator.isHost(string2) && !HttpHeadersValidator.isToken(string2)) {
            return false;
        }
        string2 = stringTokenizer.nextToken("").trim();
        int n = BasicRules.getLastQuotedString(string2, 0);
        if (n == string2.length()) {
            return true;
        }
        String string3 = string2.substring(n);
        if (string3.charAt(string3.length()) != '\"') {
            return false;
        }
        if (string2.charAt(0) != '\"') {
            return false;
        }
        return HttpHeadersValidator.isHTTPDate(string2.substring(1, string3.length() - 1));
    }

    private static boolean isValidVia(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            int n = (string2 = stringTokenizer2.nextToken()).indexOf("/");
            if (n == -1 ? !HttpHeadersValidator.isToken(string2) : !HttpHeadersValidator.isToken(string2.substring(0, n)) || !HttpHeadersValidator.isToken(string2.substring(n + 1))) {
                return false;
            }
            string2 = stringTokenizer2.nextToken();
            if (!HttpHeadersValidator.isHost(string2) && !HttpHeadersValidator.isToken(string2)) {
                return false;
            }
            if (!stringTokenizer2.hasMoreTokens() || HttpHeadersValidator.isComment((string2 = stringTokenizer2.nextToken("")).trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean isHost(String string) {
        try {
            URL uRL = new URL("http://" + string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    private static boolean isValidAllow(String string) {
        if (string.trim().length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (HttpHeadersValidator.isToken(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidContentRange(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!string.startsWith("bytes")) {
            return false;
        }
        String string2 = string.substring("bytes".length()).trim();
        int n = string2.indexOf("/");
        if (n == -1) {
            return false;
        }
        String string3 = string2.substring(0, n);
        int n2 = string3.indexOf("-");
        if (n2 == -1 ? !string3.equals("*") : !HttpHeadersValidator.isDidgit(string3.substring(0, n2)) || !HttpHeadersValidator.isDidgit(string3.substring(n2 + 1))) {
            return false;
        }
        return HttpHeadersValidator.isDidgit(string2.substring(n + 1)) || string2.substring(n + 1).equals("*");
    }

    private static boolean isRange(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!string.startsWith("bytes=")) {
            return false;
        }
        String string2 = string.substring("bytes=".length());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("-");
            if (n == -1) {
                return false;
            }
            if (!(n == 0 ? !HttpHeadersValidator.isDidgit(string3.substring(1)) : (n == string3.length() - 1 ? !HttpHeadersValidator.isDidgit(string3.substring(0, string3.length() - 1)) : !HttpHeadersValidator.isDidgit(string3.substring(0, n)) || !HttpHeadersValidator.isDidgit(string3.substring(n + 1))))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidTE(String string) {
        if (string.trim().length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringTokenizer.equals("trailers")) {
                return true;
            }
            int n = string2.indexOf(";");
            if (n == -1) {
                if (HttpHeadersValidator.isLanguageRange(string2)) continue;
                return false;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!HttpHeadersValidator.isLanguageRange(string3)) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(string4)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidUserAgent(String string) {
        if (string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (HttpHeadersValidator.isProduct(string2) || HttpHeadersValidator.isComment(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isComment(String string) {
        return BasicRules.getLastComment(string, 0) == string.length();
    }

    private static boolean isValidAcceptLanguage(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(";");
            if (n == -1) {
                if (HttpHeadersValidator.isToken(string2)) continue;
                return false;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!HttpHeadersValidator.isToken(string3)) {
                return false;
            }
            if (HttpHeadersValidator.isAcceptParams(string4)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLanguageRange(String string) {
        if (string.trim().equals("*")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        while (stringTokenizer.hasMoreElements()) {
            if (HttpHeadersValidator.is8ALPHA(stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAcceptEncoding(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(";");
            if (n == -1) {
                if (HttpHeadersValidator.isToken(string2) || string2.equals("*")) continue;
                return false;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!HttpHeadersValidator.isToken(string3) && !string3.equals("*")) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(string4)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAcceptCharSet(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(";");
            if (n == -1) {
                if (HttpHeadersValidator.isToken(string2) || string2.equals("*")) continue;
                return false;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (!HttpHeadersValidator.isToken(string3) && !string3.equals("*")) {
                return false;
            }
            if (HttpHeadersValidator.isQAndQValue(string4)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAccept(String string) {
        if (string.trim().length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(";");
            if (!(n == -1 ? !HttpHeadersValidator.isMediaRange(string2) : !HttpHeadersValidator.isMediaRange(string2.substring(0, n).trim()) || !HttpHeadersValidator.isAcceptParams(string2.substring(n + 1).trim()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAcceptParams(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = stringTokenizer.nextToken();
        int n = string2.indexOf("=");
        if (n == -1 ? string2.equals("q") || !HttpHeadersValidator.isToken(string2) : (string2.substring(0, n).equals("q") ? !HttpHeadersValidator.isQValue(string2.substring(n + 1)) : !HttpHeadersValidator.isParameterWithoutValue(string2))) {
            return false;
        }
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            if (HttpHeadersValidator.isParameterWithoutValue(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isQAndQValue(String string) {
        if (!(string = string.trim()).trim().startsWith("q=")) {
            return false;
        }
        return HttpHeadersValidator.isQValue(string.substring("q=".length()));
    }

    private static boolean isQValue(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            if (!"0".equals(string) && !"1".equals(string)) {
                return false;
            }
        } else {
            String string2 = string.substring(n + 1);
            if (string2.length() > 3) {
                return false;
            }
            if (string.substring(0, n).equals("0")) {
                if (!HttpHeadersValidator.isDidgit(string2)) {
                    return false;
                }
            } else {
                if (!string.substring(0, n).equals("1")) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.charAt(i) == '0') continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isMediaRange(String string) {
        if (string.trim().length() == 0) {
            return false;
        }
        int n = string.indexOf("/");
        if (n == -1) {
            return false;
        }
        if (!HttpHeadersValidator.isToken(string.substring(0, n)) && !string.substring(0, n).equals("*")) {
            return false;
        }
        return HttpHeadersValidator.isToken(string.substring(n + 1)) || string.substring(n + 1).equals("*");
    }

    private static boolean isEntityTag(String string) {
        int n = 0;
        if (string.startsWith("W/")) {
            n = 2;
        }
        return HttpHeadersValidator.isQuotedString(string.substring(n));
    }

    private static boolean isExpectation(String string) {
        if (string.equals("100-continue")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            if (HttpHeadersValidator.isParameterWithoutValue(stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCredentials(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!HttpHeadersValidator.isToken(stringTokenizer.nextToken())) {
            return false;
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken(",");
            if (HttpHeadersValidator.isParameter(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isProduct(String string) {
        int n = string.indexOf("/");
        return !(n == -1 ? !HttpHeadersValidator.isToken(string) : !HttpHeadersValidator.isToken(string.substring(0, n)) || !HttpHeadersValidator.isToken(string.substring(n + 1)));
    }

    private static boolean isTransferCoding(String string) {
        if (string.equals("chunked")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!HttpHeadersValidator.isToken(stringTokenizer.nextToken())) {
            return false;
        }
        while (stringTokenizer.hasMoreElements()) {
            if (HttpHeadersValidator.isParameter(stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean isParameter(String string) {
        int n = string.indexOf("=");
        if (!HttpHeadersValidator.isToken(string.substring(0, n))) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return HttpHeadersValidator.isToken(string2) || HttpHeadersValidator.isQuotedString(string2);
    }

    private static boolean isParameterWithoutValue(String string) {
        int n = string.indexOf("=");
        if (n != -1) {
            if (!HttpHeadersValidator.isToken(string.substring(0, n))) {
                return false;
            }
            String string2 = string.substring(n + 1);
            if (!HttpHeadersValidator.isToken(string2) && !HttpHeadersValidator.isQuotedString(string2)) {
                return false;
            }
        } else if (!HttpHeadersValidator.isToken(string)) {
            return false;
        }
        return true;
    }

    private static boolean isPragmaDerective(String string) {
        if (string.equals("no-cache")) {
            return true;
        }
        int n = string.indexOf("=");
        if (n == -1) {
            if (HttpHeadersValidator.isToken(string)) {
                return true;
            }
        } else {
            String string2 = string.substring(n + 1);
            if (HttpHeadersValidator.isToken(string.substring(0, n)) && (HttpHeadersValidator.isToken(string2) || HttpHeadersValidator.isQuotedString(string2))) {
                return true;
            }
        }
        return true;
    }

    private static boolean isHTTPDate(String string) {
        SimpleDateFormat simpleDateFormat;
        String string2 = "EEE, dd MMM yyyy hh:mm:ss 'GMT'";
        String string3 = "EEEE, dd-MMM-yy hh:mm:ss 'GMT'";
        String string4 = "EEE MMM d hh:mm:ss yyyy";
        try {
            simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
            if (simpleDateFormat.parse(string) != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            simpleDateFormat = new SimpleDateFormat(string3, Locale.US);
            if (simpleDateFormat.parse(string) != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            simpleDateFormat = new SimpleDateFormat(string4, Locale.US);
            if (simpleDateFormat.parse(string) != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isURI(String string) {
        try {
            URL uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = new URL("http://localhost" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                return false;
            }
        }
        return true;
    }

    private static boolean isLanguageTag(String string) {
        int n = string.indexOf("-");
        if (n == -1) {
            return HttpHeadersValidator.is8ALPHA(string);
        }
        return HttpHeadersValidator.is8ALPHA(string.substring(0, n)) && HttpHeadersValidator.is8ALPHA(string.substring(n + 1));
    }

    private static boolean is8ALPHA(String string) {
        return string.length() <= 8 && HttpHeadersValidator.isALPHA(string);
    }

    private static boolean isALPHA(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (BasicRules.isCHAR(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDidgit(String string) {
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isMediaType(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = stringTokenizer.nextToken();
        if (!HttpHeadersValidator.isToken(string2.substring(0, n = string2.indexOf("/"))) || !HttpHeadersValidator.isToken(string2.substring(n + 1))) {
            return false;
        }
        while (stringTokenizer.hasMoreElements()) {
            if (HttpHeadersValidator.isParameter(stringTokenizer.nextToken(";").trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean isQuotedString(String string) {
        return BasicRules.getLastQuotedString(string, 0) == string.length();
    }

    private static boolean isText(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\"') continue;
            return false;
        }
        return true;
    }

    private static boolean isToken(String string) {
        return BasicRules.isToken(string);
    }

    public static class MailboxValidator {
        private static final char[] SPECIAL = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '.', '[', ']'};

        public static boolean validateMailbox(String string) {
            return MailboxValidator.isFullAddr(string) || MailboxValidator.isShortAddr(string);
        }

        private static boolean isShortAddr(String string) {
            int n = string.indexOf(64);
            if (n == -1) {
                return false;
            }
            return MailboxValidator.isLocalPart(string.substring(0, n)) && MailboxValidator.isDomain(string.substring(n + 1));
        }

        private static boolean isDomain(String string) {
            if (string.trim().length() == 0) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (MailboxValidator.isAtom(string2) || MailboxValidator.isDomainLiteral(string2)) continue;
                return false;
            }
            return true;
        }

        private static boolean isDomainLiteral(String string) {
            return MailboxValidator.getLastDomainLiteral(string, 0) == string.length();
        }

        private static int getLastDomainLiteral(String string, int n) {
            int n2;
            block5: {
                n2 = n;
                if (n == string.length()) {
                    return n;
                }
                if (string.charAt(n2) != '[') {
                    return n;
                }
                ++n2;
                do {
                    if ((n2 = MailboxValidator.getLastDtext(string, n2)) == string.length()) {
                        return n;
                    }
                    if (!BasicRules.isQuotedPair(string, n2 - 1)) break block5;
                } while (++n2 != string.length());
                return n;
            }
            if (string.charAt(n2) != ']') {
                return n;
            }
            return ++n2;
        }

        private static int getLastDtext(String string, int n) {
            int n2;
            if (string.length() == n) {
                return n;
            }
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                n2 = BasicRules.getLastIndexLWS(string, n2);
                if (BasicRules.isCHAR(c) && string.charAt(n2) != '[' && string.charAt(n2) != ']' && string.charAt(n2) != '\\' && string.charAt(n2) != '\r') continue;
                return n2 + 1;
            }
            return n2 + 1;
        }

        private static boolean isLocalPart(String string) {
            if (string.trim().length() == 0) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                if (MailboxValidator.isWord(stringTokenizer.nextToken())) continue;
                return false;
            }
            return true;
        }

        private static boolean isWord(String string) {
            return MailboxValidator.isAtom(string) || HttpHeadersValidator.isQuotedString(string);
        }

        private static boolean isAtom(String string) {
            if (string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (BasicRules.isCHAR(string.charAt(i)) && !MailboxValidator.isSpecial(string.charAt(i)) && string.charAt(i) != ' ' && !BasicRules.isCTL(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static boolean isSpecial(char c) {
            for (int i = 0; i < SPECIAL.length; ++i) {
                if (c != SPECIAL[i]) continue;
                return true;
            }
            return false;
        }

        private static boolean isFullAddr(String string) {
            int n;
            if (string.length() == 0) {
                return false;
            }
            int n2 = string.indexOf(60);
            if (n2 == -1) {
                return false;
            }
            String string2 = string.substring(0, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.countTokens() == 0) {
                return false;
            }
            while (stringTokenizer.hasMoreTokens()) {
                if (MailboxValidator.isWord(stringTokenizer.nextToken())) continue;
                return false;
            }
            if (string2.charAt(string2.length() - 1) != ' ') {
                return false;
            }
            String string3 = string.substring(n2 + 1);
            int n3 = string3.indexOf(58);
            if (n3 != -1) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3.substring(0, n3), ",");
                if (!stringTokenizer2.hasMoreTokens()) {
                    return false;
                }
                while (stringTokenizer2.hasMoreTokens()) {
                    if (MailboxValidator.isDomain(stringTokenizer2.nextToken())) continue;
                    return false;
                }
            }
            if ((n = string3.indexOf(62)) == -1 || n != string3.length() - 1) {
                return false;
            }
            return MailboxValidator.isShortAddr(string3.substring(n3 + 1, n));
        }
    }
}

