/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.profile.ProfileAssertions;

public final class Utils {
    public static final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static ResourceBundle javaEncodingResource = null;
    private static final String JAVA_ENCODING_RESOURCE = "org.wsi.test.util.JavaEncoding";
    private static final String JAVA_ENCODING_DEFAULT = "UTF-8";

    public static final void logError(String string) {
        System.err.println("Error: " + string);
    }

    public static final String getExceptionDetails(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Exception: ");
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String getTimestamp() {
        timestampFormat.setTimeZone(TimeZone.getDefault());
        return timestampFormat.format(new Date());
    }

    public static String getDate() {
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date());
    }

    public static String getHTTPStatusCode(String string) throws WSIException {
        int n;
        int n2;
        String string2 = null;
        if (string.startsWith("HTTP")) {
            n2 = string.indexOf(" ");
            n = string.indexOf(" ", n2 + 1);
            if (n2 == -1 || n == -1) {
                throw new WSIException("Could not find status code in http headers: [" + string + "].");
            }
        } else {
            throw new WSIException("Could not find status code in http headers: [" + string + "].");
        }
        string2 = string.substring(n2 + 1, n);
        return string2;
    }

    public static String getHTTPHeaders(String string) {
        int n = string.indexOf("\r\n\r\n");
        n = n != -1 ? (n += 4) : string.indexOf("<?xml");
        if (n < 0) {
            Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + string);
            return "x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + string + "].";
        }
        return string.substring(0, n);
    }

    public static String getMessage(String string) {
        String string2 = "";
        int n = string.indexOf("\r\n\r\n");
        n = n != -1 ? (n += 4) : string.indexOf("<?xml");
        if (n < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + string);
            string2 = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + string + "].";
        } else {
            string2 = n >= string.length() ? "" : string.substring(n);
        }
        return string2;
    }

    public static InputStream getInputStream(String string) throws IOException {
        URL uRL;
        InputStream inputStream;
        block10: {
            inputStream = null;
            try {
                uRL = new URL(string);
                inputStream = Utils.getInputStream(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                boolean bl = false;
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
                catch (Exception exception) {
                    System.out.println("Exception in getInputStream :" + exception.toString());
                }
                if (!bl) break block10;
                inputStream = ClassLoader.getSystemResourceAsStream(string);
            }
        }
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null && (uRL = Thread.currentThread().getContextClassLoader().getResource(string)) != null) {
            inputStream = Utils.getInputStream(uRL);
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Could not locate resource file: " + string);
        }
        return inputStream;
    }

    public static InputStream getInputStream(URL uRL) throws IOException, ConnectException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (ConnectException connectException) {
            throw new ConnectException("Could not connect to URL: " + uRL.toExternalForm() + ".");
        }
        return bufferedInputStream;
    }

    public static boolean fileExists(String string) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file = new File(string);
                bl = file.exists();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String getLocalHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "127.0.0.1";
        }
        return string;
    }

    public static String formatURL(String string, String string2, String string3) {
        String string4 = string3;
        if (!string4.startsWith("/")) {
            string4 = "/" + string3;
        }
        return "http://" + string + ":" + string2 + string4;
    }

    public static String replaceString(String string, String string2, String string3) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        String string4 = string;
        int n4 = string4.indexOf(string2);
        while (n4 < string4.length() - 1 && n4 != -1) {
            string4 = string4.substring(0, n4) + string3 + string4.substring(n4 + n2);
            n = n4;
            n4 = string4.indexOf(string2, n + n3);
        }
        return string4;
    }

    public static String toHexString(String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        char[] cArray2 = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray2[n3++] = cArray[by >>> 4 & 0xF];
            cArray2[n3++] = cArray[by & 0xF];
        }
        return new String(cArray2);
    }

    public static String getHTTPCharset(String string) {
        String string2 = null;
        string2 = string.toUpperCase();
        int[] nArray = new int[]{-1, -1, -1};
        int n = string2.indexOf("CHARSET");
        int n2 = Integer.MAX_VALUE;
        if (n < 17) {
            return "";
        }
        if ((n = string2.indexOf("=", n + 7)) == -1) {
            return "";
        }
        nArray[0] = string2.indexOf("'", ++n);
        nArray[1] = string2.indexOf("\r\n", n);
        nArray[2] = string2.indexOf("\"", n);
        for (int i = 0; i < 3; ++i) {
            if (!(nArray[i] != -1 & n2 > nArray[i])) continue;
            n2 = nArray[i];
        }
        if (n2 != Integer.MAX_VALUE) {
            string2 = string.substring(n, n2);
            string2.trim();
        } else {
            string2 = "";
        }
        return string2;
    }

    public static String getXMLEncoding(String string) {
        String string2 = null;
        int n = string.indexOf("<?xml");
        int n2 = -1;
        if (n != -1 && (n2 = string.indexOf("?>", n)) > n) {
            string2 = string.substring(n, n2);
        }
        if (string2 != null) {
            n = string2.indexOf("encoding");
            if (n == -1) {
                string2 = "";
            } else {
                string2 = string2.substring(n + 8);
                string2 = string2.trim();
            }
        } else {
            return "";
        }
        if (string2.length() > 3) {
            n = string2.indexOf("=");
            if (n == 0) {
                string2 = string2.substring(1);
            } else {
                return "";
            }
        }
        if (string2.length() > 3) {
            String string3 = "\"";
            n = string2.indexOf(string3);
            if (n != 0) {
                string3 = "'";
                n = string2.indexOf("'");
            }
            string2 = n == 0 ? ((n2 = string2.indexOf(string3, 3)) != -1 ? string2.substring(1, n2) : "") : "";
        }
        return string2;
    }

    public static String getJavaEncoding(String string) {
        if (string == null || string.length() == 0) {
            return JAVA_ENCODING_DEFAULT;
        }
        try {
            if (javaEncodingResource == null) {
                javaEncodingResource = ResourceBundle.getBundle(JAVA_ENCODING_RESOURCE);
            }
            return javaEncodingResource.getString(string);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static Vector arrayToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(objectArray[i]);
        }
        return vector;
    }

    public static boolean isValidProfileTADVersion(ProfileAssertions profileAssertions) {
        boolean bl = false;
        String string = profileAssertions.getTADName();
        String string2 = profileAssertions.getTADVersion();
        if ("Basic Profile Test Assertions".equals(string)) {
            bl = Utils.checkVersionNumber("1.0.1", string2);
        }
        return bl;
    }

    private static boolean checkVersionNumber(String string, String string2) {
        boolean bl = true;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer2.hasMoreTokens()) continue;
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                bl = n >= n2;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

