/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11;

import java.lang.reflect.Constructor;
import java.util.List;
import org.w3c.dom.Element;
import org.wsi.test.validator.Artifact;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Configuration;
import org.wsi.test.validator.ServiceExtension;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.ExtensibleSecurityTokenProfile;
import org.wsi.test.validator.bsp11.SecureEnvelopeArtifact;
import org.wsi.test.validator.service.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBSP11
implements ProfileService {
    private static final String TAD_ATTRIB_ASSERTIONID = "id";
    private static final String TAD_ATTRIB_TYPE = "type";

    public Assertion getAssertion(Element assertionEl) throws ValidatorException {
        String id = assertionEl.getAttribute(TAD_ATTRIB_ASSERTIONID);
        try {
            String className = "org.wsi.test.validator.bsp11.tests." + id;
            Class<Assertion> klass = Class.forName(className).asSubclass(Assertion.class);
            Constructor<Assertion> constructor = klass.getConstructor(Element.class);
            Assertion assertion = constructor.newInstance(assertionEl);
            return assertion;
        }
        catch (Exception e) {
            if (!id.startsWith("BSP699")) {
                throw new ValidatorException(e);
            }
            return null;
        }
    }

    public static List<ExtensibleSecurityTokenProfile> getSecurityTokenExtensions() throws ValidatorException {
        return new ServiceExtension("org.wsi.test.validator.bsp10.tokenprofiles.txt").getServiceInstances();
    }

    public Artifact getArtifact(Element artifactElement) throws ValidatorException {
        String artifactName = artifactElement.getAttribute(TAD_ATTRIB_TYPE);
        if (artifactName.equals("secureEnvelope")) {
            return new SecureEnvelopeArtifact(artifactElement, this);
        }
        return null;
    }

    public String getReportNamespace() {
        return "http://www.ws-i.org/testing/2004/07/report/";
    }

    public String getConformanceReportTitle() {
        return "WS-I Basic Security Profile Conformance Report";
    }

    public Configuration getConfiguration(String configFile) throws ValidatorException {
        return new Configuration(configFile, (ProfileService)this);
    }

    public String getReleaseDateString() {
        return "2009-09-24";
    }

    public String getReleaseYearString() {
        return "2009";
    }

    public String getVersionString() {
        return "1.1.1 [BSP 1.1]";
    }
}

