/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.entrytypes;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.EntryResult;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.SecureEntryResult;
import org.wsi.test.validator.bsp11.entrytypes.SoapEnvelopeEntryType;

public abstract class SecureEntryType
extends Entry {
    public SecureEntryType(Element e) {
        super(e);
    }

    public String getTextNodeContents() throws ValidatorException {
        NodeList children = this.getElement().getChildNodes();
        String contents = null;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 3) {
                if (contents == null) {
                    contents = ((Text)children.item(i)).getData();
                } else {
                    throw new ValidatorException("Unexpectedly found more than one TEXT_NODE");
                }
            }
            ++i;
        }
        return contents;
    }

    public Element getSoapEnvelope() {
        Element place = this.getElement();
        while (!SoapEnvelopeEntryType.getFactory().isValidElement(place)) {
            place = (Element)place.getParentNode();
        }
        return place;
    }

    protected String getWsuIdOrId() {
        String idString = this.getWsuIdAttribute();
        if (idString != null) {
            return idString;
        }
        return this.getIdAttribute();
    }

    protected String getWsuIdAttribute() {
        if (this.getElement().hasAttributeNS(SecureConstants.WSU_NAMESPACE, "Id")) {
            return this.getElement().getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id");
        }
        return null;
    }

    protected String getIdAttribute() {
        if (this.getElement().hasAttribute("Id")) {
            return this.getElement().getAttribute("Id");
        }
        return null;
    }

    protected EntryResult getEntryResultInstance(Entry e, String id) {
        return new SecureEntryResult(e, id);
    }

    public static abstract class Factory {
        public abstract boolean isValidElement(Element var1);

        public abstract SecureEntryType newInstance(Element var1);

        public SecureEntryType[] collectFromSoapEnvelope(Element envelope) {
            ArrayList<SecureEntryType> result = new ArrayList<SecureEntryType>();
            if (this.isValidElement(envelope)) {
                result.add(this.newInstance(envelope));
            }
            NodeList allElements = envelope.getElementsByTagName("*");
            int i = 0;
            while (i < allElements.getLength()) {
                Element thisEl = (Element)allElements.item(i);
                if (this.isValidElement(thisEl)) {
                    result.add(this.newInstance(thisEl));
                }
                ++i;
            }
            return result.toArray(new SecureEntryType[0]);
        }

        protected boolean checkURIandName(Element el, String uri, String name) {
            String elUri = el.getNamespaceURI();
            if (elUri == null) {
                return false;
            }
            if (!elUri.equals(uri)) {
                return false;
            }
            return el.getLocalName().equals(name);
        }
    }
}

