/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.entrytypes;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecurityHeaderEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SigReferenceEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SignedInfoEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SoapEnvelopeEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SoapHeaderEntryType;

public class SignatureEntryType
extends SecureEntryType {
    private static Factory fInstance = new Factory();

    public static Factory getFactory() {
        return fInstance;
    }

    private SignatureEntryType(Element e) {
        super(e);
    }

    public String getEntryTypeTag() {
        return "signature";
    }

    public Element getSignedInfo() throws ValidatorException {
        NodeList allChildren = this.getElement().getChildNodes();
        int i = 0;
        while (i < allChildren.getLength()) {
            if (allChildren.item(i).getNodeType() == 1) {
                Element childEl = (Element)allChildren.item(i);
                if (SignedInfoEntryType.getFactory().isValidElement(childEl)) {
                    return childEl;
                }
            }
            ++i;
        }
        throw new ValidatorException("SIGNATURE has no SIGNED_INFO child");
    }

    private boolean sameSiblingPosition(Node el1, Node el2) {
        int el1Count = 0;
        Node currentNode = el1;
        while (currentNode != null) {
            currentNode = currentNode.getPreviousSibling();
            ++el1Count;
        }
        int el2Count = 0;
        currentNode = el2;
        while (currentNode != null) {
            currentNode = currentNode.getPreviousSibling();
            ++el2Count;
        }
        return el1Count == el2Count;
    }

    public boolean isEnvelopingSignature() throws ValidatorException {
        SignedInfoEntryType signedInfoEntry = (SignedInfoEntryType)SignedInfoEntryType.getFactory().newInstance(this.getSignedInfo());
        Element[] refs = signedInfoEntry.getReferences();
        int i = 0;
        while (i < refs.length) {
            SigReferenceEntryType refEntry = (SigReferenceEntryType)SigReferenceEntryType.getFactory().newInstance(refs[i]);
            Element referenced = refEntry.itemReferenced();
            if (referenced != null) {
                Node refParentSecurityHeader;
                Node myParentSecurityHeader;
                Element sig;
                Element refSigParent = null;
                Node place = referenced.getParentNode();
                while (place.getNodeType() == 1 && refSigParent == null) {
                    if (SignatureEntryType.getFactory().isValidElement((Element)place)) {
                        refSigParent = (Element)place;
                    }
                    place = place.getParentNode();
                }
                if (refSigParent != null && this.sameSiblingPosition(sig = this.getElement(), refSigParent) && this.sameSiblingPosition(myParentSecurityHeader = sig.getParentNode(), refParentSecurityHeader = refSigParent.getParentNode())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isEnvelopedSignature() throws ValidatorException {
        SignedInfoEntryType signedInfoEntry = (SignedInfoEntryType)SignedInfoEntryType.getFactory().newInstance(this.getSignedInfo());
        Element[] refs = signedInfoEntry.getReferences();
        int i = 0;
        while (i < refs.length) {
            SigReferenceEntryType refEntry = (SigReferenceEntryType)SigReferenceEntryType.getFactory().newInstance(refs[i]);
            Element referenced = refEntry.itemReferenced();
            if (referenced != null) {
                if (SecurityHeaderEntryType.getFactory().isValidElement(referenced)) {
                    if (this.sameSiblingPosition(referenced, this.getElement().getParentNode())) {
                        return true;
                    }
                } else {
                    if (SoapHeaderEntryType.getFactory().isValidElement(referenced)) {
                        return true;
                    }
                    if (SoapEnvelopeEntryType.getFactory().isValidElement(referenced)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isDetachedSignature() throws ValidatorException {
        return !this.isEnvelopedSignature() && !this.isEnvelopingSignature();
    }

    /* synthetic */ SignatureEntryType(Element element, SignatureEntryType signatureEntryType) {
        this(element);
    }

    public static class Factory
    extends SecureEntryType.Factory {
        private Factory() {
        }

        public SecureEntryType newInstance(Element e) {
            return new SignatureEntryType(e, null);
        }

        public boolean isValidElement(Element el) {
            if (!this.checkURIandName(el, SecureConstants.DS_NAMESPACE, "Signature")) {
                return false;
            }
            Element parent = (Element)el.getParentNode();
            return SecurityHeaderEntryType.getFactory().isValidElement(parent);
        }
    }
}

