/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.wsi.test.validator.Assertion;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.entrytypes.EkDataReferenceEntryType;

public class BSP3006
extends Assertion {
    public BSP3006(Element assertionEl) {
        super(assertionEl);
    }

    public boolean isApplicable(Entry e) {
        return e instanceof EkDataReferenceEntryType;
    }

    public boolean applyRule(Entry entry) {
        Element referencedElement;
        EkDataReferenceEntryType target = (EkDataReferenceEntryType)entry;
        try {
            referencedElement = target.itemReferenced();
        }
        catch (ValidatorException e) {
            e.printStackTrace();
            return false;
        }
        if (referencedElement == null) {
            return false;
        }
        return this.isEncryptedData(referencedElement) || this.isEncryptedHeader(referencedElement);
    }

    private boolean isEncryptedData(Element e) {
        return e.getNamespaceURI().equals(SecureConstants.XENC_NAMESPACE) && e.getLocalName().equals("EncryptedData");
    }

    private boolean isEncryptedHeader(Element e) {
        return e.getNamespaceURI().equals(SecureConstants.WSSE11_NAMESPACE) && e.getLocalName().equals("EncryptedHeader");
    }
}

