/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.XPathAssertion;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedKeyEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecurityTokenReferenceEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SignatureEntryType;
import org.wsi.test.validator.bsp11.entrytypes.UsernameTokenEntryType;

public class BSP4217
extends XPathAssertion {
    public BSP4217(Element e) throws ValidatorException {
        super(e);
    }

    public boolean isApplicable(Entry e) {
        if (e instanceof SecurityTokenReferenceEntryType) {
            SecurityTokenReferenceEntryType ref = (SecurityTokenReferenceEntryType)e;
            Element parent = (Element)ref.getElement().getParentNode();
            if (SignatureEntryType.getFactory().isValidElement(parent) || EncryptedKeyEntryType.getFactory().isValidElement(parent)) {
                Element token = null;
                try {
                    token = ref.getReferencedSecurityTokenElement();
                }
                catch (ValidatorException e1) {
                    e1.printStackTrace();
                }
                if (token != null) {
                    return UsernameTokenEntryType.getFactory().isValidElement(token);
                }
            }
        }
        return false;
    }

    public boolean applyRule(Entry entry) {
        SecurityTokenReferenceEntryType ref = (SecurityTokenReferenceEntryType)entry;
        Element token = null;
        try {
            token = ref.getReferencedSecurityTokenElement();
        }
        catch (ValidatorException e1) {
            e1.printStackTrace();
        }
        NodeList saltList = token.getElementsByTagNameNS(SecureConstants.WSSE11_NAMESPACE, "Salt");
        return saltList.getLength() > 0;
    }
}

