/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp11.tests;

import org.w3c.dom.Element;
import org.wsi.test.validator.Entry;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp11.SecureConstants;
import org.wsi.test.validator.bsp11.XPathAssertion;
import org.wsi.test.validator.bsp11.entrytypes.EkReferenceListEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedDataEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedHeaderEntryType;
import org.wsi.test.validator.bsp11.entrytypes.EncryptedKeyEntryType;
import org.wsi.test.validator.bsp11.entrytypes.SecureEntryType;

public class BSP5629
extends XPathAssertion {
    public BSP5629(Element assertionEl) throws ValidatorException {
        super(assertionEl);
    }

    public boolean isApplicable(Entry e) {
        if (!(e instanceof EncryptedDataEntryType)) {
            return false;
        }
        EncryptedDataEntryType entry = (EncryptedDataEntryType)e;
        Element soapEnvelope = entry.getSoapEnvelope();
        SecureEntryType[] entries = EncryptedKeyEntryType.getFactory().collectFromSoapEnvelope(soapEnvelope);
        String thisId = entry.getElement().getAttribute("Id");
        String wsuId = null;
        Element eHeader = (Element)e.getElement().getParentNode();
        if (EncryptedHeaderEntryType.getFactory().isValidElement(eHeader) && (wsuId = eHeader.getAttributeNS(SecureConstants.WSU_NAMESPACE, "Id")).equals("")) {
            wsuId = null;
        }
        int i = 0;
        while (i < entries.length) {
            EncryptedKeyEntryType ek = (EncryptedKeyEntryType)entries[i];
            Element refListElement = ek.getReferenceList();
            if (refListElement != null) {
                EkReferenceListEntryType refList = (EkReferenceListEntryType)EkReferenceListEntryType.getFactory().newInstance(refListElement);
                String[] uris = refList.getAllReferenceURIs();
                int j = 0;
                while (j < uris.length) {
                    if (uris[j].substring(1).equals(thisId)) {
                        return false;
                    }
                    if (wsuId != null && uris[j].substring(1).equals(wsuId)) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }
}

